/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.util.HashMap;
import java.util.Map;

public enum ColorSpaceID {
    RGB("RGB: The first three values in the color data are red, green, and blue", 0),
    HSB("HSB:  The first three values in the color data are hue, saturation, and brightness", 1),
    CMYK("CMYK: The four values in the color data are cyan, magenta, yellow, and black", 2),
    PANTONE("Pantone matching system", 3),
    FOCOLTONE("Focoltone colour system", 4),
    TRUMATCH("Trumatch color", 5),
    TOYO88("Toyo 88 colorfinder 1050", 6),
    Lab("Lab: The first three values in the color data are lightness, a chrominance, and b chrominance", 7),
    Grayscale("Grayscale: The first value in the color data is the gray value, from 0...10000", 8),
    HKS("HKS colors", 10),
    UNKNOWN("Unknown", 99);

    private static final Map<Integer, ColorSpaceID> idMap;
    private final String description;
    private final int value;

    private ColorSpaceID(String string2, int n2) {
        this.description = string2;
        this.value = n2;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public static ColorSpaceID fromInt(int n) {
        ColorSpaceID colorSpaceID = idMap.get(n);
        if (colorSpaceID == null) {
            return UNKNOWN;
        }
        return colorSpaceID;
    }

    static {
        idMap = new HashMap<Integer, ColorSpaceID>();
        for (ColorSpaceID colorSpaceID : ColorSpaceID.values()) {
            idMap.put(colorSpaceID.getValue(), colorSpaceID);
        }
    }
}

