/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static final short LITTLE_ENDIAN = 18761;
    public static final short BIG_ENDIAN = 19789;

    public static void close(InputStream inputStream) throws IOException {
        inputStream.close();
    }

    public static void close(OutputStream outputStream) throws IOException {
        outputStream.close();
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static int read(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        return inputStream.read(byArray);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        return inputStream.read(byArray, n, n2);
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(IOUtils.readLong(inputStream));
    }

    public static double readDoubleMM(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(IOUtils.readLongMM(inputStream));
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(IOUtils.readInt(inputStream));
    }

    public static float readFloatMM(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(IOUtils.readIntMM(inputStream));
    }

    public static byte[] readFully(InputStream inputStream, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        while (n2 > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public static int readInt(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public static int readIntMM(byte[] byArray, int n) {
        return (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
    }

    public static int readIntMM(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static long readLong(byte[] byArray, int n) {
        return (long)byArray[n++] & 0xFFL | (((long)byArray[n++] & 0xFFL) << 8 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n] & 0xFFL) << 56);
    }

    public static long readLong(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        IOUtils.readFully(inputStream, byArray);
        return ((long)byArray[7] & 0xFFL) << 56 | ((long)byArray[6] & 0xFFL) << 48 | ((long)byArray[5] & 0xFFL) << 40 | ((long)byArray[4] & 0xFFL) << 32 | ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[1] & 0xFFL) << 8 | (long)byArray[0] & 0xFFL;
    }

    public static long readLongMM(byte[] byArray, int n) {
        return ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n] & 0xFFL;
    }

    public static long readLongMM(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        IOUtils.readFully(inputStream, byArray);
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public static float readS15Fixed16MMNumber(byte[] byArray, int n) {
        short s = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return (float)s + (float)n2 / 65536.0f;
    }

    public static float readS15Fixed16MMNumber(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        short s = (short)(byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8);
        int n = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8;
        return (float)s + (float)n / 65536.0f;
    }

    public static float readS15Fixed16Number(byte[] byArray, int n) {
        short s = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
        int n2 = byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
        return (float)s + (float)n2 / 65536.0f;
    }

    public static float readS15Fixed16Number(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        short s = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
        int n = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        return (float)s + (float)n / 65536.0f;
    }

    public static short readShort(byte[] byArray, int n) {
        return (short)(byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8);
    }

    public static short readShort(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        IOUtils.readFully(inputStream, byArray);
        return (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    public static short readShortMM(byte[] byArray, int n) {
        return (short)((byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
    }

    public static short readShortMM(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        IOUtils.readFully(inputStream, byArray);
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public static long readUnsignedInt(byte[] byArray, int n) {
        return (long)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long readUnsignedInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        return (long)((byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUnsignedIntMM(byte[] byArray, int n) {
        return (long)IOUtils.readIntMM(byArray, n) & 0xFFFFFFFFL;
    }

    public static long readUnsignedIntMM(InputStream inputStream) throws IOException {
        return (long)IOUtils.readIntMM(inputStream) & 0xFFFFFFFFL;
    }

    public static int readUnsignedShort(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
    }

    public static int readUnsignedShort(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        IOUtils.readFully(inputStream, byArray);
        return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public static int readUnsignedShortMM(byte[] byArray, int n) {
        return (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int readUnsignedShortMM(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        IOUtils.readFully(inputStream, byArray);
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public static long skip(InputStream inputStream, long l) throws IOException {
        return inputStream.skip(l);
    }

    public static void skipFully(InputStream inputStream, int n) throws IOException {
        IOUtils.readFully(inputStream, new byte[n]);
    }

    public static void write(OutputStream outputStream, byte[] byArray) throws IOException {
        outputStream.write(byArray);
    }

    public static void write(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(byArray, n, n2);
    }

    public static void write(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n);
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)});
    }

    public static void writeIntMM(OutputStream outputStream, int n) throws IOException {
        outputStream.write(new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n});
    }

    public static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write(new byte[]{(byte)l, (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56)});
    }

    public static void writeLongMM(OutputStream outputStream, long l) throws IOException {
        outputStream.write(new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l});
    }

    public static void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(new byte[]{(byte)n, (byte)(n >>> 8)});
    }

    public static void writeShortMM(OutputStream outputStream, int n) throws IOException {
        outputStream.write(new byte[]{(byte)(n >>> 8), (byte)n});
    }

    private IOUtils() {
    }
}

