/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import pixy.io.WriteStrategy;
import pixy.io.WriteStrategyMM;

public class EndianAwareOutputStream
extends OutputStream
implements DataOutput {
    private OutputStream out;
    private WriteStrategy strategy = WriteStrategyMM.getInstance();

    public EndianAwareOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setWriteStrategy(WriteStrategy writeStrategy) {
        this.strategy = writeStrategy;
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        new DataOutputStream(this).writeBytes(string);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.writeShort(c);
        }
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeInt(int n) throws IOException {
        byte[] byArray = new byte[4];
        this.strategy.writeInt(byArray, 0, n);
        this.write(byArray, 0, 4);
    }

    @Override
    public void writeLong(long l) throws IOException {
        byte[] byArray = new byte[8];
        this.strategy.writeLong(byArray, 0, l);
        this.write(byArray, 0, 8);
    }

    public void writeS15Fixed16Number(float f) throws IOException {
        byte[] byArray = new byte[4];
        this.strategy.writeS15Fixed16Number(byArray, 0, f);
        this.write(byArray, 0, 4);
    }

    @Override
    public void writeShort(int n) throws IOException {
        byte[] byArray = new byte[2];
        this.strategy.writeShort(byArray, 0, n);
        this.write(byArray, 0, 2);
    }

    public void writeU16Fixed16Number(float f) throws IOException {
        byte[] byArray = new byte[4];
        this.strategy.writeU16Fixed16Number(byArray, 0, f);
        this.write(byArray, 0, 4);
    }

    public void writeU8Fixed8Number(float f) throws IOException {
        byte[] byArray = new byte[2];
        this.strategy.writeU8Fixed8Number(byArray, 0, f);
        this.write(byArray, 0, 2);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        new DataOutputStream(this).writeUTF(string);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

