/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.tiff;

import java.io.IOException;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.Tag;
import pixy.image.tiff.TiffTag;
import pixy.io.RandomAccessOutputStream;
import pixy.string.StringUtils;

public abstract class TiffField<T>
implements Comparable<TiffField<?>> {
    private final short tag;
    private final FieldType fieldType;
    private final int length;
    protected T data;
    protected static final int MAX_STRING_REPR_LEN = 10;
    protected int dataOffset;

    public TiffField(short s, FieldType fieldType, int n) {
        this.tag = s;
        this.fieldType = fieldType;
        this.length = n;
    }

    @Override
    public int compareTo(TiffField<?> tiffField) {
        return (this.tag & 0xFFFF) - (tiffField.tag & 0xFFFF);
    }

    public T getData() {
        return this.data;
    }

    public int[] getDataAsLong() {
        throw new UnsupportedOperationException("getDataAsLong() method is only supported by short, long, and rational data types");
    }

    public abstract String getDataAsString();

    public int getLength() {
        return this.length;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public short getTag() {
        return this.tag;
    }

    public FieldType getType() {
        return this.fieldType;
    }

    public String toString() {
        short s = this.getTag();
        Tag tag = TiffTag.fromShort(s);
        if (tag != TiffTag.UNKNOWN) {
            return tag.toString();
        }
        return tag.toString() + " [TiffTag value: " + StringUtils.shortToHexStringMM(s) + "]";
    }

    public final int write(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        randomAccessOutputStream.writeShort(this.tag);
        randomAccessOutputStream.writeShort(this.getType().getValue());
        randomAccessOutputStream.writeInt(this.getLength());
        return this.writeData(randomAccessOutputStream, n);
    }

    protected abstract int writeData(RandomAccessOutputStream var1, int var2) throws IOException;
}

