/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.tiff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pixy.image.tiff.IFD;
import pixy.image.tiff.ShortField;
import pixy.image.tiff.Tag;
import pixy.image.tiff.TiffField;
import pixy.image.tiff.TiffTag;
import pixy.io.RandomAccessInputStream;
import pixy.io.RandomAccessOutputStream;
import pixy.meta.tiff.TIFFMeta;

public class TIFFImage
implements Iterable<IFD> {
    private int numOfPages;
    private int workingPage;
    private List<IFD> ifds = new ArrayList<IFD>();
    private RandomAccessInputStream rin;

    public TIFFImage(RandomAccessInputStream randomAccessInputStream) throws IOException {
        this.rin = randomAccessInputStream;
        TIFFMeta.readIFDs(this.ifds, randomAccessInputStream);
        this.numOfPages = this.ifds.size();
        this.workingPage = 0;
    }

    public void addField(TiffField<?> tiffField) {
        this.ifds.get(this.workingPage).addField(tiffField);
    }

    public TiffField<?> getField(Tag tag) {
        return this.ifds.get(this.workingPage).getField(tag);
    }

    public List<IFD> getIFDs() {
        return Collections.unmodifiableList(this.ifds);
    }

    public RandomAccessInputStream getInputStream() {
        return this.rin;
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public TiffField<?> removeField(Tag tag) {
        return this.ifds.get(this.workingPage).removeField(tag);
    }

    public IFD removePage(int n) {
        IFD iFD = this.ifds.remove(n);
        --this.numOfPages;
        return iFD;
    }

    public void setWorkingPage(int n) {
        if (n < 0 || n >= this.numOfPages) {
            throw new IllegalArgumentException("Invalid page number: " + n);
        }
        this.workingPage = n;
    }

    public void write(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        if (this.numOfPages > 1) {
            for (int i = 0; i < this.ifds.size(); ++i) {
                this.ifds.get(i).removeField(TiffTag.PAGE_NUMBER);
                this.ifds.get(i).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)(this.numOfPages - 1)}));
            }
        }
        TIFFMeta.write(this, randomAccessOutputStream);
    }

    @Override
    public Iterator<IFD> iterator() {
        return this.ifds.iterator();
    }
}

