/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.tiff;

import java.io.IOException;
import java.util.Arrays;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.TiffField;
import pixy.io.RandomAccessOutputStream;

public class FloatField
extends TiffField<float[]> {
    public FloatField(short s, float[] fArray) {
        super(s, FieldType.FLOAT, fArray.length);
        this.data = fArray;
    }

    @Override
    public float[] getData() {
        return (float[])((float[])this.data).clone();
    }

    @Override
    public String getDataAsString() {
        return Arrays.toString((float[])this.data);
    }

    @Override
    protected int writeData(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        if (((float[])this.data).length == 1) {
            this.dataOffset = (int)randomAccessOutputStream.getStreamPointer();
            randomAccessOutputStream.writeFloat(((float[])this.data)[0]);
        } else {
            this.dataOffset = n;
            randomAccessOutputStream.writeInt(n);
            randomAccessOutputStream.seek(n);
            for (float f : (float[])this.data) {
                randomAccessOutputStream.writeFloat(f);
            }
            n += ((float[])this.data).length << 2;
        }
        return n;
    }
}

