/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.tiff;

import java.io.IOException;
import java.util.Arrays;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.TiffField;
import pixy.io.RandomAccessOutputStream;

public class DoubleField
extends TiffField<double[]> {
    public DoubleField(short s, double[] dArray) {
        super(s, FieldType.DOUBLE, dArray.length);
        this.data = dArray;
    }

    @Override
    public double[] getData() {
        return (double[])((double[])this.data).clone();
    }

    @Override
    public String getDataAsString() {
        return Arrays.toString((double[])this.data);
    }

    @Override
    protected int writeData(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        this.dataOffset = n;
        randomAccessOutputStream.writeInt(n);
        randomAccessOutputStream.seek(n);
        for (double d : (double[])this.data) {
            randomAccessOutputStream.writeDouble(d);
        }
        return n += ((double[])this.data).length << 3;
    }
}

