/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.IOException;
import java.io.OutputStream;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkType;
import pixy.io.IOUtils;

public class UnknownChunk
extends Chunk {
    private final int chunkValue;

    public UnknownChunk(long l, int n, byte[] byArray, long l2) {
        super(ChunkType.UNKNOWN, l, byArray, l2);
        this.chunkValue = n;
    }

    public int getChunkValue() {
        return this.chunkValue;
    }

    @Override
    public boolean isValidCRC() {
        return UnknownChunk.calculateCRC(this.chunkValue, this.getData()) == this.getCRC();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        IOUtils.writeIntMM(outputStream, (int)this.getLength());
        IOUtils.writeIntMM(outputStream, this.chunkValue);
        IOUtils.write(outputStream, this.getData());
        IOUtils.writeIntMM(outputStream, (int)this.getCRC());
    }

    @Override
    public String toString() {
        return super.toString() + "[Chunk type value: 0x" + Integer.toHexString(this.chunkValue) + "]";
    }
}

