/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.DeflaterOutputStream;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkBuilder;
import pixy.image.png.ChunkType;
import pixy.util.Builder;

public class TextBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private boolean compressed;
    private String keyword;
    private String text;

    public TextBuilder(ChunkType chunkType) {
        super(chunkType);
        if (chunkType != ChunkType.TEXT && chunkType != ChunkType.ITXT && chunkType != ChunkType.ZTXT) {
            throw new IllegalArgumentException("Expect Textual chunk!");
        }
    }

    @Override
    protected byte[] buildData() {
        byte[] byArray = null;
        ChunkType chunkType = this.getChunkType();
        StringBuilder stringBuilder = new StringBuilder(this.keyword);
        stringBuilder.append('\u0000');
        switch (chunkType) {
            case TEXT: {
                stringBuilder.append(this.text);
                try {
                    byArray = stringBuilder.toString().getBytes("iso-8859-1");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case ZTXT: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    stringBuilder.append('\u0000');
                    byteArrayOutputStream.write(stringBuilder.toString().getBytes("iso-8859-1"));
                    DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)deflaterOutputStream, "iso-8859-1");
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                    bufferedWriter.write(this.text);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case ITXT: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byteArrayOutputStream.write(stringBuilder.toString().getBytes("iso-8859-1"));
                    OutputStreamWriter outputStreamWriter = null;
                    if (this.compressed) {
                        byteArrayOutputStream.write(new byte[]{1, 0, 0, 0});
                        outputStreamWriter = new OutputStreamWriter((OutputStream)new DeflaterOutputStream(byteArrayOutputStream), "UTF-8");
                    } else {
                        byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
                        outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                    }
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                    bufferedWriter.write(this.text);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
        }
        return byArray;
    }

    public TextBuilder keyword(String string) {
        this.keyword = string.trim().replaceAll("\\s+", " ");
        return this;
    }

    public void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    public TextBuilder text(String string) {
        this.text = string;
        return this;
    }
}

