/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.IOException;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkType;
import pixy.io.IOUtils;
import pixy.util.Reader;

public class IHDRReader
implements Reader {
    private int width = 0;
    private int height = 0;
    private byte bitDepth = 0;
    private byte colorType = 0;
    private byte compressionMethod = 0;
    private byte filterMethod = 0;
    private byte interlaceMethod = 0;
    private Chunk chunk;

    public IHDRReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.IHDR) {
            throw new IllegalArgumentException("Not a valid IHDR chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IHDRReader: error reading chunk");
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public byte getColorType() {
        return this.colorType;
    }

    public byte getCompressionMethod() {
        return this.compressionMethod;
    }

    public byte getFilterMethod() {
        return this.filterMethod;
    }

    public byte getInterlaceMethod() {
        return this.interlaceMethod;
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.chunk.getData();
        this.width = IOUtils.readIntMM(byArray, 0);
        this.height = IOUtils.readIntMM(byArray, 4);
        this.bitDepth = byArray[8];
        this.colorType = byArray[9];
        this.compressionMethod = byArray[10];
        this.filterMethod = byArray[11];
        this.interlaceMethod = byArray[12];
    }
}

