/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkType;
import pixy.util.Reader;

public class IENDReader
implements Reader {
    private Chunk chunk;
    private static final Logger LOGGER = LoggerFactory.getLogger(IENDReader.class);

    public IENDReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.IEND) {
            throw new IllegalArgumentException("Not a valid IEND chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IENDReader: error reading chunk");
        }
    }

    @Override
    public void read() throws IOException {
        if (this.chunk.getData().length != 0) {
            LOGGER.warn("Warning: IEND data field is not empty!");
        }
    }
}

