/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.DeflaterOutputStream;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkBuilder;
import pixy.image.png.ChunkType;
import pixy.util.Builder;

public class ICCPBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private String profileName;
    private byte[] profileData;

    public ICCPBuilder() {
        super(ChunkType.ICCP);
    }

    public ICCPBuilder data(byte[] byArray) {
        this.profileData = byArray;
        return this;
    }

    public ICCPBuilder name(String string) {
        this.profileName = string.trim().replaceAll("\\s+", " ");
        return this;
    }

    @Override
    protected byte[] buildData() {
        StringBuilder stringBuilder = new StringBuilder(this.profileName);
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            byteArrayOutputStream.write(stringBuilder.toString().getBytes("iso-8859-1"));
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(deflaterOutputStream);
            bufferedOutputStream.write(this.profileData);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

