/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.jpeg;

import java.io.IOException;
import java.util.EnumSet;
import pixy.image.jpeg.Component;
import pixy.image.jpeg.Marker;
import pixy.image.jpeg.Segment;
import pixy.io.IOUtils;
import pixy.util.Reader;

public class SOFReader
implements Reader {
    private int precision;
    private int frameHeight;
    private int frameWidth;
    private int numOfComponents;
    private Component[] components;
    private static final EnumSet<Marker> SOFS = EnumSet.of(Marker.SOF0, new Marker[]{Marker.SOF1, Marker.SOF2, Marker.SOF3, Marker.SOF5, Marker.SOF6, Marker.SOF7, Marker.SOF9, Marker.SOF10, Marker.SOF11, Marker.SOF13, Marker.SOF14, Marker.SOF15});
    private Segment segment;

    public SOFReader(Segment segment) throws IOException {
        if (!SOFS.contains((Object)segment.getMarker())) {
            throw new IllegalArgumentException("Not a valid SOF segment: " + segment.getMarker());
        }
        this.segment = segment;
        this.read();
    }

    public int getLength() {
        return this.segment.getLength();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getNumOfComponents() {
        return this.numOfComponents;
    }

    public Component[] getComponents() {
        return (Component[])this.components.clone();
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.segment.getData();
        this.precision = byArray[0];
        this.frameHeight = IOUtils.readUnsignedShortMM(byArray, 1);
        this.frameWidth = IOUtils.readUnsignedShortMM(byArray, 3);
        this.numOfComponents = byArray[5];
        this.components = new Component[this.numOfComponents];
        int n = 6;
        for (int i = 0; i < this.numOfComponents; ++i) {
            byte by = byArray[n++];
            byte by2 = byArray[n++];
            byte by3 = (byte)(by2 >> 4 & 0xF);
            byte by4 = (byte)(by2 & 0xF);
            byte by5 = byArray[n++];
            this.components[i] = new Component(by, by3, by4, by5);
        }
    }
}

