/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.jpeg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import pixy.image.jpeg.JPGConsts;
import pixy.image.jpeg.Marker;
import pixy.image.jpeg.QTable;
import pixy.image.jpeg.Segment;
import pixy.io.IOUtils;
import pixy.util.Reader;

public class DQTReader
implements Reader {
    private Segment segment;
    private List<QTable> qTables = new ArrayList<QTable>(4);

    public DQTReader(Segment segment) throws IOException {
        if (segment.getMarker() != Marker.DQT) {
            throw new IllegalArgumentException("Not a valid DQT segment!");
        }
        this.segment = segment;
        this.read();
    }

    public List<QTable> getTables() {
        return this.qTables;
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.segment.getData();
        int n = this.segment.getLength();
        n -= 2;
        int n2 = 0;
        int[] nArray = JPGConsts.getDeZigzagMatrix();
        while (n > 0) {
            int n3;
            byte by = byArray[n2++];
            --n;
            int n4 = by >> 4 & 0xF;
            int n5 = by & 0xF;
            int n6 = 64 << n4;
            int[] nArray2 = new int[64];
            if (n4 == 0) {
                for (n3 = 0; n3 < 64; ++n3) {
                    nArray2[n3] = byArray[nArray[n3] + n2] & 0xFF;
                }
            } else {
                for (n3 = 0; n3 < 64; ++n3) {
                    nArray2[n3] = IOUtils.readUnsignedShortMM(byArray, n2 + nArray[n3] << 1);
                }
            }
            this.qTables.add(new QTable(n4, n5, nArray2));
            n -= n6;
            n2 += n6;
        }
    }
}

