/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.EventListener;

public class EventCollector
implements EventListener {
    private boolean logConnectionIdentifiers = false;
    private boolean logCommands = true;
    private boolean logTransferStartComplete = true;
    private boolean logTransferProgress = false;
    private StringBuffer log = new StringBuffer();

    public boolean isLogConnectionIdentifiers() {
        return this.logConnectionIdentifiers;
    }

    public void setLogConnectionIdentifiers(boolean logConnectionIdentifiers) {
        this.logConnectionIdentifiers = logConnectionIdentifiers;
    }

    public boolean isLogCommands() {
        return this.logCommands;
    }

    public void setLogCommands(boolean logCommands) {
        this.logCommands = logCommands;
    }

    public boolean isLogTransferStartComplete() {
        return this.logTransferStartComplete;
    }

    public void setLogTransferStartComplete(boolean logTransferStartComplete) {
        this.logTransferStartComplete = logTransferStartComplete;
    }

    public boolean isLogTransferProgress() {
        return this.logTransferProgress;
    }

    public void setLogTransferProgress(boolean logTransferProgress) {
        this.logTransferProgress = logTransferProgress;
    }

    public String getLog() {
        return this.log.toString();
    }

    public void clearLog() {
        this.log = new StringBuffer();
    }

    public void commandSent(String connId, String cmd) {
        if (this.logCommands) {
            if (this.logConnectionIdentifiers) {
                this.log.append('[').append(connId).append("] ");
            }
            this.log.append(cmd).append("\n");
        }
    }

    public void replyReceived(String connId, String reply) {
        if (this.logCommands) {
            if (this.logConnectionIdentifiers) {
                this.log.append('[').append(connId).append("] ");
            }
            this.log.append(reply).append("\n");
        }
    }

    public void downloadStarted(String connId, String remoteFilename) {
        if (this.logTransferStartComplete) {
            if (this.logConnectionIdentifiers) {
                this.log.append('[').append(connId).append("] ");
            }
            this.log.append("Started download: ").append(remoteFilename).append("\n");
        }
    }

    public void downloadCompleted(String connId, String remoteFilename) {
        if (this.logTransferStartComplete) {
            if (this.logConnectionIdentifiers) {
                this.log.append('[').append(connId).append("] ");
            }
            this.log.append("Completed download: ").append(remoteFilename).append("\n");
        }
    }

    public void uploadStarted(String connId, String remoteFilename) {
        if (this.logTransferStartComplete) {
            if (this.logConnectionIdentifiers) {
                this.log.append('[').append(connId).append("] ");
            }
            this.log.append("Started upload: ").append(remoteFilename).append("\n");
        }
    }

    public void uploadCompleted(String connId, String remoteFilename) {
        if (this.logTransferStartComplete) {
            if (this.logConnectionIdentifiers) {
                this.log.append('[').append(connId).append("] ");
            }
            this.log.append("Completed upload: ").append(remoteFilename).append("\n");
        }
    }

    public void bytesTransferred(String connId, String remoteFilename, long count) {
        if (this.logTransferProgress) {
            if (this.logConnectionIdentifiers) {
                this.log.append('[').append(connId).append("] ");
            }
            this.log.append(remoteFilename).append(" - ").append(count).append("\n");
        }
    }
}

