/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.translators;

import com.github.cliftonlabs.json_simple.JsonException;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.jalbum.translators.Main;
import net.jalbum.translators.TranslateException;
import net.jalbum.util.Work;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.TextEditor;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;

public class TranslatorPlugin
implements JAlbumPlugin {
    private PluginContext context;
    private JAlbumFrame window;
    Action translateSelectedSkin = new AbstractAction("Translate selected skin"){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File skinDir = TranslatorPlugin.this.context.getJAlbumContext().getSkinDir();
                File textsDir = new File(skinDir, "texts");
                File englishText = new File(textsDir, "texts.properties");
                TranslatorPlugin.this.assertTranslateable(textsDir);
                File currentText = TranslatorPlugin.getCurrentLanguageFile(textsDir);
                if (!currentText.exists()) {
                    int answer = JOptionPane.showConfirmDialog((Component)TranslatorPlugin.this.window, "This skin is missing a translation for the currently selected language.\nA copy of the English translation file will be be generated for the currently selected language.\nJust change the English texts to the right of the = signs to your language.", "Translate selected skin", 2, 2);
                    if (answer != 0) {
                        return;
                    }
                    IO.copyFile((File)englishText, (File)currentText);
                }
                TextEditor.openDocument((File)englishText);
                TextEditor.openDocument((File)currentText);
            }
            catch (IOException | TranslateException ex) {
                Debug.showErrorDialog((Component)TranslatorPlugin.this.window, (Throwable)ex);
            }
        }
    };
    Action translateJalbum = new AbstractAction("Translate jAlbum"){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File progDir = Config.getConfig().progDir;
                File textsDir = new File(progDir, "texts");
                File englishText = new File(textsDir, "texts.properties");
                if (!englishText.exists()) {
                    JOptionPane.showMessageDialog((Component)TranslatorPlugin.this.window, "Sorry. Can't find the English reference translation.\n(Missing texts/texts.properties file)", "Translate jAlbum", 0);
                    return;
                }
                File currentText = TranslatorPlugin.getCurrentLanguageFile(textsDir);
                if (!currentText.exists()) {
                    System.out.println(currentText.getAbsolutePath());
                    int answer = JOptionPane.showConfirmDialog((Component)TranslatorPlugin.this.window, "jAlbum is missing a translation for the currently selected language.\nA copy of the English translation file will be be generated for the currently selected language.\nJust change the English texts to the right of the = signs to your language.", "Translate jAlbum", 2, 2);
                    if (answer != 0) {
                        return;
                    }
                    IO.copyFile((File)englishText, (File)currentText);
                }
                TextEditor.openDocument((File)englishText);
                TranslatorPlugin.viewEndOfDocument();
                TextEditor.openDocument((File)currentText);
                TranslatorPlugin.viewEndOfDocument();
            }
            catch (IOException ex) {
                Debug.showErrorDialog((Component)TranslatorPlugin.this.window, (Throwable)ex);
            }
        }
    };
    Action updateSkinTranslation = new AbstractAction("Update skin translation"){
        {
            this.putValue("ShortDescription", "Add texts that are not yet translated to current skin translation");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranslatorPlugin.this.updateTranslation((String)this.getValue("Name"), new File(TranslatorPlugin.this.context.getJAlbumContext().getSkinDir(), "texts"), false);
        }
    };
    Action updateJalbumTranslation = new AbstractAction("Update jAlbum translation"){
        {
            this.putValue("ShortDescription", "Add texts that are not yet translated to current jAlbum translation");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranslatorPlugin.this.updateTranslation((String)this.getValue("Name"), new File(Config.getConfig().progDir, "texts"), false);
        }
    };
    Action updateSkinTranslationAuto = new AbstractAction("Update skin translation (auto-translate)"){
        {
            this.putValue("ShortDescription", "Add texts that are not yet translated to current skin translation. Use Google Translate to auto-translate");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranslatorPlugin.this.updateTranslation((String)this.getValue("Name"), new File(TranslatorPlugin.this.context.getJAlbumContext().getSkinDir(), "texts"), true);
        }
    };
    Action updateAllSkinTranslationsAuto = new AbstractAction("Update ALL skin translations (auto-translate)"){
        {
            this.putValue("ShortDescription", "Add texts that are not yet translated to all skin translations. Use Google Translate to auto-translate");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranslatorPlugin.this.updateAllTranslations((String)this.getValue("Name"), new File(TranslatorPlugin.this.context.getJAlbumContext().getSkinDir(), "texts"));
        }
    };
    Action updateJalbumTranslationAuto = new AbstractAction("Update jAlbum translation (auto-translate)"){
        {
            this.putValue("ShortDescription", "Add texts that are not yet translated to current jAlbum translation. Use Google Translate to auto-translate");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranslatorPlugin.this.updateTranslation((String)this.getValue("Name"), new File(Config.getConfig().progDir, "texts"), true);
        }
    };
    Action findSkinTranslation = new AbstractAction("Find skin translation"){
        {
            this.putValue("ShortDescription", "Find translation file in file system");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File translationFile = TranslatorPlugin.getCurrentLanguageFile(new File(TranslatorPlugin.this.context.getJAlbumContext().getSkinDir(), "texts"));
            try {
                BrowserLauncher.showInFileSystem((File)translationFile);
            }
            catch (IOException ex) {
                Debug.showErrorDialog((Component)TranslatorPlugin.this.window, (Throwable)ex);
            }
        }
    };
    Action findJalbumTranslation = new AbstractAction("Find jAlbum translation"){
        {
            this.putValue("ShortDescription", "Find translation file in file system");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File translationFile = TranslatorPlugin.getCurrentLanguageFile(new File(Config.getConfig().progDir, "texts"));
            try {
                BrowserLauncher.showInFileSystem((File)translationFile);
            }
            catch (IOException ex) {
                Debug.showErrorDialog((Component)TranslatorPlugin.this.window, (Throwable)ex);
            }
        }
    };

    private void assertTranslateable(File textsDir) throws TranslateException {
        File englishText = new File(textsDir, "texts.properties");
        if (!englishText.exists()) {
            throw new TranslateException("Sorry. This skin is not prepared for translation\n(Missing texts/texts.properties file)");
        }
    }

    public void init(PluginContext context) {
        this.context = context;
        this.window = context.getJAlbumContext().getFrame();
        JMenu menu = new JMenu("Translator");
        menu.add(new JMenuItem(this.translateSelectedSkin));
        menu.add(this.updateSkinTranslation);
        menu.add(this.updateSkinTranslationAuto);
        menu.add(this.updateAllSkinTranslationsAuto);
        menu.add(this.findSkinTranslation);
        menu.addSeparator();
        menu.add(new JMenuItem(this.translateJalbum));
        menu.add(this.updateJalbumTranslation);
        menu.add(this.updateJalbumTranslationAuto);
        menu.add(this.findJalbumTranslation);
        context.addToolsMenuItem((JMenuItem)menu);
    }

    public boolean onExit() {
        return true;
    }

    private static void viewEndOfDocument() {
        try {
            JTextComponent editor = TextEditor.getCurrentEditorComponent();
            editor.setCaretPosition(editor.getDocument().getLength());
        }
        catch (AbstractMethodError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    private void updateTranslation(String title, File textsDir, boolean autoTranslate) {
        try {
            int count = this.updateTranslation(title, textsDir, Config.getConfig().getInterpretedLanguage(), autoTranslate);
            if (count == 0) {
                JOptionPane.showMessageDialog((Component)this.window, "The current translation is complete", "Update translation", 1);
            }
        }
        catch (OperationAbortedException count) {
        }
        catch (JsonException | HeadlessException | IOException | BadLocationException | TranslateException ex) {
            Debug.showErrorDialog((Component)this.window, (Throwable)ex);
        }
    }

    private void updateAllTranslations(String title, File textsDir) {
        try {
            int count = 0;
            for (String lang : Main.getAvailableLanguages(textsDir)) {
                count += this.updateTranslation(title, textsDir, lang, true);
            }
            if (count == 0) {
                JOptionPane.showMessageDialog((Component)this.window, "All translations are complete", "Update all translations", 1);
            }
        }
        catch (OperationAbortedException count) {
        }
        catch (JsonException | HeadlessException | IOException | BadLocationException | TranslateException ex) {
            Debug.showErrorDialog((Component)this.window, (Throwable)ex);
        }
    }

    private int updateTranslation(String title, File textsDir, String lang, boolean autoTranslate) throws IOException, JsonException, BadLocationException, TranslateException {
        this.assertTranslateable(textsDir);
        File englishText = new File(textsDir, "texts.properties");
        File currentText = TranslatorPlugin.getLanguageFile(textsDir, lang);
        if (!currentText.exists()) {
            currentText.createNewFile();
        }
        if (currentText.equals(englishText)) {
            return 0;
        }
        Map<String, String> texts = IO.readMapFile((File)englishText, (boolean)true);
        Map current = IO.readMapFile((File)currentText);
        for (Object key : current.keySet()) {
            texts.remove(key);
        }
        if (texts.size() > 0) {
            if (autoTranslate) {
                texts = TranslatorPlugin.autoTranslate(texts, lang);
            }
            TextEditor.openDocument((File)currentText);
            JTextComponent editor = TextEditor.getCurrentEditorComponent();
            Document doc = editor.getDocument();
            editor.moveCaretPosition(doc.getLength());
            int selectionStart = doc.getLength();
            doc.insertString(doc.getLength(), Main.createContent(texts, autoTranslate), null);
            editor.setSelectionStart(selectionStart);
            editor.setSelectionEnd(doc.getLength());
        }
        return texts.size();
    }

    private static File getCurrentLanguageFile(File textsDir) {
        return TranslatorPlugin.getLanguageFile(textsDir, Config.getConfig().getInterpretedLanguage());
    }

    private static File getLanguageFile(File textsDir, String lang) {
        if ("en".equals(lang)) {
            return new File(textsDir, "texts.properties");
        }
        return new File(textsDir, "texts_" + lang + ".properties");
    }

    static Map<String, String> autoTranslate(Map<String, String> all, String targetLang) throws IOException, JsonException {
        LinkedHashMap<String, String> translated = new LinkedHashMap<String, String>();
        Work work = Work.on(all.entrySet()).titled("Translating to " + targetLang).forEach(e -> translated.put((String)e.getKey(), Main.translateText((String)e.getValue(), targetLang)));
        if (work.isAborted()) {
            throw new OperationAbortedException();
        }
        return translated;
    }
}

