/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;

public class WebBinder {
    public static Map<String, Object> getMap(WebEngine engine) throws IOException {
        return WebBinder.getMap(engine, new HashMap<String, Object>());
    }

    public static Map<String, Object> getMap(WebEngine engine, Map<String, Object> vars) throws IOException {
        if (Platform.isFxApplicationThread()) {
            return WebBinder.doGetMap(engine, vars);
        }
        try {
            return new FXWorker<Map>().invokeAndWait(() -> WebBinder.doGetMap(engine, vars));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private static Map<String, Object> doGetMap(WebEngine engine, Map<String, Object> vars) throws IOException {
        int formCount;
        Object lengthObj = engine.executeScript("document.forms.length");
        int n = formCount = lengthObj instanceof Number ? ((Number)lengthObj).intValue() : 0;
        if (formCount == 0) {
            throw new IOException("Skin user interface missing <form> tag");
        }
        int elementsLength = ((Number)engine.executeScript("document.forms[0].elements.length")).intValue();
        block8: for (int i = 0; i < elementsLength; ++i) {
            String name = (String)engine.executeScript("document.forms[0].elements[" + i + "].name");
            String type = (String)engine.executeScript("document.forms[0].elements[" + i + "].type");
            if (name == null || name.isEmpty() || type == null) continue;
            switch (type) {
                case "checkbox": {
                    Object checked = engine.executeScript("document.forms[0].elements[" + i + "].checked");
                    vars.put(name, checked);
                    continue block8;
                }
                case "radio": {
                    Boolean isChecked = (Boolean)engine.executeScript("document.forms[0].elements[" + i + "].checked");
                    if (!Boolean.TRUE.equals(isChecked)) continue block8;
                    Object value = engine.executeScript("document.forms[0].elements[" + i + "].value");
                    vars.put(name, value);
                    continue block8;
                }
                default: {
                    Object value = engine.executeScript("document.forms[0].elements[" + i + "].value");
                    vars.put(name, value);
                }
            }
        }
        return vars;
    }

    public static void syncUI(Map<String, Object> vars, WebEngine engine) throws IOException {
        if (Platform.isFxApplicationThread()) {
            WebBinder.doSyncUI(vars, engine);
        } else {
            try {
                new FXWorker<Void>().invokeAndWait(() -> {
                    WebBinder.doSyncUI(vars, engine);
                    return null;
                });
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    private static void doSyncUI(Map<String, Object> vars, WebEngine engine) throws IOException {
        int formCount;
        Object formLengthObj = engine.executeScript("document.forms.length");
        int n = formCount = formLengthObj instanceof Number ? ((Number)formLengthObj).intValue() : 0;
        if (formCount == 0) {
            throw new IOException("Skin user interface missing <form> tag");
        }
        for (Map.Entry<String, Object> e : vars.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            String script = "var control = document.forms[0].elements.namedItem('" + name + "');if(control) {  var type = control.type;  var oldVal;  switch(type) {    case 'checkbox': oldVal = control.checked; control.checked = " + WebBinder.toJsValue(value) + "; break;    case 'file': break;    default: oldVal = control.value; control.value = " + WebBinder.toJsValue(value) + "; break;  }  if(oldVal !== (type==='checkbox'?control.checked:control.value)) {    control.dispatchEvent(new Event('change'));  }}";
            engine.executeScript(script);
        }
    }

    private static String toJsValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        return "'" + value.toString().replace("'", "\\'") + "'";
    }

    private static class FXWorker<V> {
        private Exception ex;
        private V ret;
        private CountDownLatch workerLatch;

        private FXWorker() {
        }

        public V invokeAndWait(Callable<V> callable) throws Exception {
            this.workerLatch = new CountDownLatch(1);
            this.ex = null;
            Platform.runLater(() -> {
                try {
                    this.ret = callable.call();
                }
                catch (Exception ex) {
                    this.ex = ex;
                }
                finally {
                    this.workerLatch.countDown();
                }
            });
            try {
                this.workerLatch.await();
                if (this.ex != null) {
                    throw this.ex;
                }
                return this.ret;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

