/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.util.Scanner;
import se.datadosen.util.ContextualException;

public class ScriptException
extends javax.script.ScriptException
implements ContextualException {
    private File file;

    public ScriptException(String message, File file, int lineNumber, int columnNumber) {
        super(message, file.getName(), lineNumber, columnNumber);
        this.file = file;
    }

    public ScriptException(String message, File file, int lineNumber) {
        super(message, file.getName(), lineNumber);
        this.file = file;
    }

    public ScriptException(Throwable cause, File file, int lineNumber) {
        super(ScriptException.getDetailedMessageFromCause(cause), file.getName(), lineNumber);
        this.initCause(cause.getCause());
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static ScriptException of(Throwable cause, File file, int lineNumber) {
        String msg = ScriptException.getDetailedMessageFromCause(cause);
        int line = -1;
        int column = -1;
        int atIndex = msg.indexOf(" @ line ");
        if (atIndex != -1) {
            String locPart = msg.substring(atIndex);
            msg = msg.substring(0, atIndex);
            Scanner sc = new Scanner(locPart).useDelimiter(" |,|\\.");
            while (sc.hasNext()) {
                String token = sc.next();
                if (token.equals("line")) {
                    line = sc.nextInt();
                    continue;
                }
                if (!token.equals("column")) continue;
                column = sc.nextInt();
                break;
            }
        }
        ScriptException se = new ScriptException(msg, file, lineNumber != -1 ? lineNumber : line, column);
        se.initCause(cause);
        return se;
    }

    private static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private static String getDetailedMessageFromCause(Throwable cause) {
        javax.script.ScriptException se;
        int locationIndex;
        cause = ScriptException.getRootCause(cause);
        String msg = cause.toString();
        if (cause instanceof javax.script.ScriptException && (locationIndex = msg.indexOf(" in " + (se = (javax.script.ScriptException)cause).getFileName())) != -1) {
            return msg.substring(0, locationIndex);
        }
        return msg;
    }
}

