/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import bsh.Primitive;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import se.datadosen.util.PrintSafeHashMap;

public class Scope
implements Map<String, Object>,
Bindings,
Serializable {
    public static final String GLOBALS_NAME = "Globals";
    protected Scope outer;
    protected Map<String, Object> map;
    private boolean flattening;
    private String name;
    public static int flattenCounter = 0;

    public String getName() {
        return this.name != null ? this.name : "Unnamed";
    }

    public Scope name(String name) {
        this.name = name;
        return this;
    }

    public Scope() {
        this.map = new PrintSafeHashMap();
    }

    public Scope(Scope outer) {
        this();
        this.outer = outer;
    }

    public Scope(Map map) {
        this.map = map;
    }

    public Scope(Map map, Scope outer) {
        this.map = map;
        this.outer = outer;
    }

    @Override
    public Object get(Object key) {
        Object res = this.map.get(key);
        if (res == null && this.outer != null) {
            res = this.outer.get(key);
        }
        return res;
    }

    public Object getUnwrapped(Object key) {
        Object o = this.get(key);
        if (o instanceof Primitive) {
            return ((Primitive)o).getValue();
        }
        return o;
    }

    @Override
    public Object put(String key, Object value) {
        this.verify(key);
        return this.map.put(key, value);
    }

    public Object putNotNull(String key, Object value) {
        if (value != null) {
            return this.put(key, value);
        }
        return null;
    }

    @Override
    public void putAll(Map more) {
        this.verify(null);
        if (more != null) {
            this.map.putAll(more);
        }
    }

    @Override
    public Object remove(Object key) {
        this.verify(key);
        return this.map.remove(key);
    }

    public Scope getOuter() {
        return this.outer;
    }

    public void setOuter(Scope outer) {
        this.outer = outer;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    protected Map<String, Object> flatten2() {
        if (this.outer == null) {
            return new PrintSafeHashMap(this.map);
        }
        Map<String, Object> flatMap = this.outer.flatten2();
        try {
            this.flattening = true;
            flatMap.putAll(this.map);
        }
        finally {
            this.flattening = false;
        }
        return flatMap;
    }

    public Map<String, Object> flatten() {
        if (this.outer == null) {
            return this.map;
        }
        ++flattenCounter;
        return this.flatten2();
    }

    private void verify(Object key) {
        if (this.flattening) {
            throw new IllegalStateException("Calling illegal method during flattening. Key is " + String.valueOf(key));
        }
    }

    public Scope push(Map map) {
        if (map == null) {
            return this;
        }
        return new Scope(map, this);
    }

    public Scope remove(Map map) {
        if (this == map) {
            return this.outer;
        }
        Scope scope = this;
        while (scope != null) {
            if (scope.outer == map) {
                scope.outer = scope.outer.outer;
                return scope;
            }
            scope = this.outer;
        }
        return this;
    }

    @Override
    public int size() {
        return this.outer != null ? this.outer.size() + this.map.size() : this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty() && (this.outer == null || this.outer.isEmpty());
    }

    @Override
    public boolean containsKey(Object key) {
        boolean contains = this.map.containsKey(key);
        if (!contains && this.outer != null) {
            return this.outer.containsKey(key);
        }
        return contains;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean contains = this.map.containsValue(value);
        if (!contains && this.outer != null) {
            return this.outer.containsValue(value);
        }
        return contains;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.flatten().keySet();
    }

    @Override
    public Collection values() {
        return this.flatten().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.flatten().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return 1;
    }

    public String toString() {
        String s = "[" + this.getName() + " @ " + System.identityHashCode(this) + ": " + this.map.size() + "]";
        if (this.outer != null) {
            s = s + "->" + String.valueOf(this.outer);
        }
        return s;
    }
}

