/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import se.datadosen.util.APP1Segment;
import se.datadosen.util.Debug;
import se.datadosen.util.JpegFile;
import se.datadosen.util.Orientation;
import se.datadosen.util.Segment;

public class RotationSupport {
    public static final int LEFT_ROTATED_FLIPPED = 5;
    public static final int LEFT_ROTATED = 6;
    public static final int NOT_ROTATED = 1;
    public static final int NOT_ROTATED_FLIPPED = 2;
    public static final int RIGHT_ROTATED_FLIPPED = 7;
    public static final int RIGHT_ROTATED = 8;
    public static final int UPSIDE_DOWN = 3;
    public static final int UPSIDE_DOWN_FLIPPED = 4;

    public static BufferedImage flip(BufferedImage bi, boolean vertically) {
        AffineTransform tx;
        if (vertically) {
            tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -bi.getHeight());
        } else {
            tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-bi.getWidth(), 0.0);
        }
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(bi, null);
    }

    public static BufferedImage rotate180(BufferedImage bi) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-bi.getWidth(), -bi.getHeight());
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(bi, null);
    }

    public static BufferedImage rotateLeft(BufferedImage bi) {
        AffineTransform rot270Transform = AffineTransform.getRotateInstance(4.71238898038469);
        rot270Transform.translate(-bi.getWidth(), 0.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot270Transform, hints);
        return op.filter(bi, null);
    }

    public static BufferedImage rotateRight(BufferedImage bi) {
        AffineTransform rot90Transform = AffineTransform.getRotateInstance(1.5707963267948966);
        rot90Transform.translate(0.0, -bi.getHeight());
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot90Transform, hints);
        return op.filter(bi, null);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, Metadata meta) {
        if (meta == null) {
            return ii;
        }
        BufferedImage bi = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
        bi = RotationSupport.adjustOrientation(bi, meta);
        return new ImageIcon(bi);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, File file) {
        try {
            BufferedImage bi = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
            bi = RotationSupport.adjustOrientation(bi, RotationSupport.getOrientation(file));
            return new ImageIcon(bi);
        }
        catch (IOException ex) {
            return ii;
        }
    }

    protected static BufferedImage createBufferedImage(Image img, int iw, int ih) {
        int type = 1;
        if (img instanceof BufferedImage) {
            type = ((BufferedImage)img).getType();
        }
        BufferedImage bi = new BufferedImage(iw, ih, type);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, Metadata meta) {
        if (meta == null) {
            return bi;
        }
        try {
            if (meta.containsDirectoryOfType(ExifSubIFDDirectory.class)) {
                Directory exif = meta.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
                int existingOrientation = exif.getInt(274);
                return RotationSupport.adjustOrientation(bi, existingOrientation);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return bi;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, File file) {
        try {
            return RotationSupport.adjustOrientation(bi, RotationSupport.getOrientation(file));
        }
        catch (IOException ex) {
            Debug.logErr(ex.toString());
            return bi;
        }
    }

    public static int getOrientation(Metadata meta) {
        try {
            if (meta.containsDirectoryOfType(ExifSubIFDDirectory.class)) {
                Directory exif = meta.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
                return exif.getInt(274);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return 1;
    }

    public static String getOrientationAsString(Metadata meta) {
        return RotationSupport.asString(RotationSupport.getOrientation(meta));
    }

    /*
     * Exception decompiling
     */
    public static int getOrientation(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getOrientationAsString(File file) {
        try {
            return RotationSupport.asString(RotationSupport.getOrientation(file));
        }
        catch (IOException ex) {
            return "normal";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setOrientation(int orientation, File file) throws IOException {
        boolean reoriented = false;
        try (JpegFile f = null;){
            Segment s;
            f = new JpegFile(file, "rw");
            for (s = f.getFirstSegment(); s != null && s.getId() != JpegSegmentType.APP1.byteValue; s = s.getNextSegment()) {
            }
            if (s != null) {
                APP1Segment app1 = new APP1Segment(s);
                boolean ifdNum = false;
                block4: do {
                    for (int i = 0; i < app1.getEntryCount(); ++i) {
                        APP1Segment.Entry ifd = app1.getEntry(i);
                        if (ifd.getTagNr() != 274) continue;
                        ifd.setValue(orientation);
                        reoriented = true;
                        continue block4;
                    }
                } while (app1.nextIFD());
            }
            if (!reoriented) {
                throw new IOException("Couldn't find orientation tag in APP1 segment");
            }
            boolean bl = reoriented;
            return bl;
        }
    }

    protected static String asString(int orientation) {
        Orientation o = Orientation.fromValue(orientation);
        return o != null ? o.name() : "unknown (" + orientation + ")";
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, Orientation existingOrientation) {
        return RotationSupport.adjustOrientation(bi, existingOrientation.getValue());
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, String existingOrientation) {
        return RotationSupport.adjustOrientation(bi, Orientation.fromName(existingOrientation).getValue());
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, int existingOrientation) {
        switch (existingOrientation) {
            case 6: {
                return RotationSupport.rotateRight(bi);
            }
            case 5: {
                return RotationSupport.rotateRight(RotationSupport.flip(bi, true));
            }
            case 8: {
                return RotationSupport.rotateLeft(bi);
            }
            case 7: {
                return RotationSupport.rotateLeft(RotationSupport.flip(bi, true));
            }
            case 3: {
                return RotationSupport.rotate180(bi);
            }
            case 4: {
                return RotationSupport.rotate180(RotationSupport.flip(bi, false));
            }
            case 2: {
                return RotationSupport.flip(bi, false);
            }
        }
        return bi;
    }
}

