/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Rectangle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JColorSelector;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Attributizer;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.ManagesImport;
import se.datadosen.util.PersistentChoice;
import se.datadosen.util.PersistentList;
import se.datadosen.util.annotations.Bound;

public class PropertyBinder {
    private static Map<Class, ComponentBinder> componentBinders = new HashMap<Class, ComponentBinder>();
    private static final ThreadLocal<Boolean> synchingUI = new ThreadLocal();

    public static Properties getProperties(JComponentHolder jComponentHolder) {
        return PropertyBinder.getProperties(jComponentHolder, new Properties());
    }

    public static <T extends Map> T getProperties(JComponentHolder jComponentHolder, T existing) {
        T props = existing;
        String name = "";
        try {
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            boolean isGroovy = false;
            for (Field field : fields) {
                Object comp;
                name = field.getName();
                if (!isGroovy && name.equals("metaClass")) {
                    isGroovy = true;
                }
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) {
                    try {
                        Method m = guiClass.getDeclaredMethod(PropertyBinder.getGetterMethodName(name), new Class[0]);
                        if (!Modifier.isPublic(m.getModifiers())) {
                        }
                    }
                    catch (NoSuchMethodException ex) {}
                    continue;
                }
                if ((comp = field.get(jComponentHolder)) == null) continue;
                if (comp instanceof JComponentHolder) {
                    if (field.getName().startsWith("this$")) continue;
                    Properties subProps = PropertyBinder.getProperties((JComponentHolder)comp);
                    props.putAll(subProps);
                    continue;
                }
                PropertyBinder.readComponent(comp, name, props, field.isAnnotationPresent(Bound.class));
            }
            if (isGroovy) {
                for (AccessibleObject accessibleObject : guiClass.getDeclaredMethods()) {
                    name = PropertyBinder.getAttributeName((Method)accessibleObject);
                    if (name == null || name.equals("metaClass") || !Modifier.isPublic(((Method)accessibleObject).getModifiers())) continue;
                    ((Method)accessibleObject).setAccessible(true);
                    Object comp = ((Method)accessibleObject).invoke(jComponentHolder, new Object[0]);
                    if (comp == null) continue;
                    if (comp instanceof JComponentHolder) {
                        Properties subProps = PropertyBinder.getProperties((JComponentHolder)comp);
                        props.putAll(subProps);
                        continue;
                    }
                    PropertyBinder.readComponent(comp, name, props, accessibleObject.isAnnotationPresent(Bound.class));
                }
            }
            return props;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException("For field " + name, ex);
        }
    }

    public static boolean isSynchingUI() {
        return Boolean.TRUE.equals(synchingUI.get());
    }

    public static void syncUI(Map props, JComponentHolder jComponentHolder) {
        try {
            synchingUI.set(Boolean.TRUE);
            PropertyBinder.doSyncUI(props, jComponentHolder);
        }
        finally {
            synchingUI.remove();
        }
    }

    private static void doSyncUI(Map props, JComponentHolder jComponentHolder) {
        try {
            Field[] fields;
            if (jComponentHolder instanceof ManagesImport) {
                ((ManagesImport)((Object)jComponentHolder)).importVariables(props);
            }
            Class<?> guiClass = jComponentHolder.getClass();
            block8: for (Field field : fields = BeanBinder.getFields(guiClass)) {
                Object comp;
                String name = field.getName();
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) {
                    try {
                        Method m = guiClass.getDeclaredMethod(PropertyBinder.getGetterMethodName(name), new Class[0]);
                        if (!Modifier.isPublic(m.getModifiers())) {
                        }
                    }
                    catch (NoSuchMethodException ex) {}
                    continue;
                }
                if ((comp = field.get(jComponentHolder)) == null || !props.containsKey(name) && !(comp instanceof JComponentHolder)) continue;
                if (comp instanceof JComponentHolder) {
                    if (field.getName().startsWith("this$")) continue;
                    PropertyBinder.doSyncUI(props, (JComponentHolder)comp);
                    continue;
                }
                Object oVal = props.get(name);
                if (oVal == null) continue;
                String value = oVal instanceof Enum ? ((Enum)oVal).name() : oVal.toString();
                try {
                    if (componentBinders.containsKey(comp.getClass()) && (comp instanceof JComponent || field.getAnnotation(Bound.class) != null)) {
                        ComponentBinder mgr = componentBinders.get(comp.getClass());
                        mgr.setValue(comp, value);
                        continue;
                    }
                    if (comp instanceof JComponent) {
                        if (comp instanceof JTextComponent) {
                            JTextComponent tc = (JTextComponent)comp;
                            tc.setText(value);
                            continue;
                        }
                        if (comp instanceof JComboBox) {
                            JComboBox jc = (JComboBox)comp;
                            boolean setOk = false;
                            for (int k = 0; k < jc.getItemCount(); ++k) {
                                Object item = jc.getItemAt(k);
                                if (item instanceof Number) {
                                    item = item.toString();
                                }
                                if (!item.equals(value)) continue;
                                jc.setSelectedIndex(k);
                                setOk = true;
                                break;
                            }
                            if (setOk) continue;
                            jc.setSelectedItem(value);
                            continue;
                        }
                        if (comp instanceof JCheckBox) {
                            JCheckBox cb = (JCheckBox)comp;
                            cb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                            continue;
                        }
                        if (comp instanceof JToggleButton) {
                            JToggleButton tb = (JToggleButton)comp;
                            tb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                            continue;
                        }
                        if (comp instanceof JColorSelector) {
                            JColorSelector cs = (JColorSelector)comp;
                            cs.setColor(value);
                            continue;
                        }
                        if (comp instanceof JSlider) {
                            JSlider js = (JSlider)comp;
                            js.setValue(Integer.parseInt(value));
                            continue;
                        }
                        if (comp instanceof PersistentList) {
                            ArrayList<String> values = new ArrayList<String>();
                            if (value.startsWith("item") && value.indexOf(9) == -1) {
                                try {
                                    String val;
                                    Properties p = AttributeTokenizer.getProperties(value);
                                    int j = 1;
                                    while ((val = p.getProperty("item" + j)) != null) {
                                        values.add(val);
                                        ++j;
                                    }
                                }
                                catch (ElementException ex) {
                                    throw new RuntimeException(ex);
                                }
                            } else {
                                StringTokenizer tokens = new StringTokenizer(value, "\t");
                                while (tokens.hasMoreTokens()) {
                                    values.add(tokens.nextToken());
                                }
                            }
                            ((PersistentList)comp).setContent(values);
                            continue;
                        }
                        if (comp instanceof PersistentChoice) {
                            ((PersistentChoice)comp).setChoice(value);
                            continue;
                        }
                        if (!(comp instanceof JTable)) continue;
                        JTable table = (JTable)comp;
                        PropertyBinder.deserializeModel(value, table.getModel());
                        continue;
                    }
                    if (!(comp instanceof ButtonGroup)) continue;
                    ButtonGroup bg = (ButtonGroup)comp;
                    Enumeration<AbstractButton> buttons = bg.getElements();
                    while (buttons.hasMoreElements()) {
                        AbstractButton button = buttons.nextElement();
                        String ac = button.getActionCommand();
                        if (ac == null || !ac.equals(value)) continue;
                        bg.setSelected(button.getModel(), true);
                        continue block8;
                    }
                }
                catch (IllegalArgumentException ex) {
                    System.err.println("Error setting \"" + value + "\" on " + comp.getClass().getSimpleName() + " component " + name + ": " + ex.getMessage());
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ComponentBinder registerComponentBinder(Class componentClass, ComponentBinder binder) {
        if (binder != null) {
            return componentBinders.put(componentClass, binder);
        }
        return componentBinders.remove(componentClass);
    }

    private static <T> void readComponent(Object comp, String name, T props, boolean boundAnnotated) {
        if (componentBinders.containsKey(comp.getClass()) && (comp instanceof JComponent || boundAnnotated)) {
            ComponentBinder mgr = componentBinders.get(comp.getClass());
            ((Map)props).put(name, mgr.getValue(comp));
        } else if (comp instanceof JComponent) {
            if (comp instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)comp;
                ((Map)props).put(name, tc.getText());
            } else if (comp instanceof JComboBox) {
                JComboBox jc = (JComboBox)comp;
                Object sel = jc.getSelectedItem();
                if (sel != null) {
                    if (sel instanceof Item) {
                        sel = ((Item)sel).value.toString();
                    } else if (sel instanceof Enum) {
                        sel = ((Enum)sel).name();
                    }
                    ((Map)props).put(name, sel.toString());
                }
            } else if (comp instanceof PersistentChoice) {
                PersistentChoice pc = (PersistentChoice)comp;
                ((Map)props).put(name, pc.getChoice());
            } else if (comp instanceof JCheckBox) {
                JCheckBox cb = (JCheckBox)comp;
                ((Map)props).put(name, cb.isSelected() ? "true" : "false");
            } else if (comp instanceof JToggleButton) {
                JToggleButton tb = (JToggleButton)comp;
                ((Map)props).put(name, tb.isSelected() ? "true" : "false");
            } else if (comp instanceof JColorSelector) {
                JColorSelector cs = (JColorSelector)comp;
                ((Map)props).put(name, cs.getHTMLColor());
            } else if (comp instanceof JSlider) {
                JSlider js = (JSlider)comp;
                ((Map)props).put(name, "" + js.getValue());
            } else if (comp instanceof PersistentList) {
                StringBuilder buf = new StringBuilder();
                for (String s : ((PersistentList)comp).getContent()) {
                    if (buf.length() > 0) {
                        buf.append('\t');
                    }
                    buf.append(s);
                }
                ((Map)props).put(name, buf.toString());
            } else if (comp instanceof JTable) {
                JTable table = (JTable)comp;
                ((Map)props).put(name, PropertyBinder.serializeModel(table.getModel()));
            }
        } else if (comp instanceof ButtonGroup) {
            ButtonGroup bg = (ButtonGroup)comp;
            Enumeration<AbstractButton> buttons = bg.getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (!button.isSelected()) continue;
                ((Map)props).put(name, button.getActionCommand());
            }
        } else if (comp instanceof Attributizer) {
            Attributizer attr = (Attributizer)comp;
            ((Map)props).put(name, attr.getAttributes());
        }
    }

    private static String getGetterMethodName(String attributeName) {
        return "get" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
    }

    private static String getAttributeName(Method method) {
        String name = method.getName();
        if (method.getParameterCount() == 0) {
            if (name.startsWith("is")) {
                return PropertyBinder.lowerInitial(name.substring(2));
            }
            if (name.startsWith("get")) {
                return PropertyBinder.lowerInitial(name.substring(3));
            }
        }
        return null;
    }

    private static String lowerInitial(String substring) {
        char[] chars = substring.toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toLowerCase(chars[0]);
        }
        return new String(chars);
    }

    private static String serializeModel(TableModel model) {
        StringBuilder buf = new StringBuilder();
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (row > 0) {
                buf.append('\n');
            }
            for (int col = 0; col < model.getColumnCount(); ++col) {
                Object val;
                if (col > 0) {
                    buf.append('\t');
                }
                if ((val = model.getValueAt(row, col)) instanceof Enum) {
                    buf.append(((Enum)val).name());
                    continue;
                }
                buf.append(val);
            }
        }
        return buf.toString();
    }

    private static void deserializeModel(String serialized, TableModel model) {
        String[] rows = serialized.split("\n");
        if (model instanceof DefaultTableModel) {
            ((DefaultTableModel)model).setRowCount(rows.length);
        }
        for (int row = 0; row < rows.length; ++row) {
            String[] cols = rows[row].split("\t");
            for (int col = 0; col < cols.length; ++col) {
                Class<?> clazz = model.getColumnClass(col);
                Object val = null;
                if (String.class.isAssignableFrom(clazz)) {
                    val = cols[col];
                } else if (Enum.class.isAssignableFrom(clazz)) {
                    try {
                        val = Enum.valueOf(clazz, cols[col]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (Integer.class.isAssignableFrom(clazz)) {
                    val = Integer.valueOf(cols[col]);
                } else if (Short.class.isAssignableFrom(clazz)) {
                    val = Short.valueOf(cols[col]);
                } else if (Byte.class.isAssignableFrom(clazz)) {
                    val = Byte.valueOf(cols[col]);
                } else if (Float.class.isAssignableFrom(clazz)) {
                    val = Float.valueOf(cols[col]);
                } else if (Double.class.isAssignableFrom(clazz)) {
                    val = Double.valueOf(cols[col]);
                } else if (Boolean.class.isAssignableFrom(clazz)) {
                    val = Boolean.valueOf(cols[col]);
                }
                if (val == null) continue;
                model.setValueAt(val, row, col);
            }
        }
    }

    static {
        PropertyBinder.registerComponentBinder(JSpinner.class, new ComponentBinder(){

            @Override
            public String getValue(Object comp) {
                return ((JSpinner)comp).getValue().toString();
            }

            @Override
            public void setValue(Object comp, String value) {
                try {
                    ((JSpinner)comp).setValue(Integer.valueOf(value));
                }
                catch (NumberFormatException ex) {
                    try {
                        ((JSpinner)comp).setValue(Double.valueOf(value));
                    }
                    catch (NumberFormatException ex2) {
                        ((JSpinner)comp).setValue(value);
                    }
                }
            }
        });
        PropertyBinder.registerComponentBinder(Rectangle.class, new ComponentBinder(){

            @Override
            public String getValue(Object comp) {
                Rectangle r = (Rectangle)comp;
                return "x=" + r.x + " y=" + r.y + " width=" + r.width + " height=" + r.height;
            }

            @Override
            public void setValue(Object comp, String value) {
                try {
                    Properties props = AttributeTokenizer.getProperties(value);
                    Rectangle r = (Rectangle)comp;
                    int x = Integer.parseInt(props.getProperty("x"));
                    int y = Integer.parseInt(props.getProperty("y"));
                    int width = Integer.parseInt(props.getProperty("width"));
                    int height = Integer.parseInt(props.getProperty("height"));
                    r.setBounds(x, y, width, height);
                }
                catch (ElementException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public static interface ComponentBinder {
        public String getValue(Object var1);

        public void setValue(Object var1, String var2);
    }
}

