/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

public enum Orientation {
    normal(1, 0),
    normalFlipped(2, 0),
    right(8, 90),
    rightFlipped(7, 90),
    upsideDown(3, 180),
    upsideDownFlipped(4, 180),
    left(6, -90),
    leftFlipped(5, -90);

    private int value;
    private int angle;

    private Orientation(int value, int angle) {
        this.value = value;
        this.angle = angle;
    }

    public int getValue() {
        return this.value;
    }

    public int getAngle() {
        return this.angle;
    }

    private static int mod(int num, int den) {
        int m = num % den;
        if (m < 0) {
            m = den + m;
        }
        return m;
    }

    public Orientation next() {
        int ordinal = Orientation.mod(this.ordinal() + 2, Orientation.values().length);
        return Orientation.values()[ordinal];
    }

    public Orientation previous() {
        int ordinal = Orientation.mod(this.ordinal() - 2, Orientation.values().length);
        return Orientation.values()[ordinal];
    }

    public boolean isFlipped() {
        return this.ordinal() % 2 != 0;
    }

    public boolean isRotated() {
        return this == left || this == leftFlipped || this == right || this == rightFlipped;
    }

    public Orientation flipped() {
        return this.isFlipped() ? Orientation.values()[this.ordinal() - 1] : Orientation.values()[this.ordinal() + 1];
    }

    public static Orientation fromValue(int value) {
        for (Orientation o : Orientation.values()) {
            if (o.getValue() != value) continue;
            return o;
        }
        return null;
    }

    public static Orientation fromName(String name) {
        return name != null ? Enum.valueOf(Orientation.class, name) : normal;
    }
}

