/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.drew.imaging.jpeg.JpegSegmentType;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import se.datadosen.util.APP1Segment;
import se.datadosen.util.JpegFile;
import se.datadosen.util.Segment;

public class JPEGUtil {
    private static final int TIFF_HEADER_START_OFFSET = 6;

    public static byte[] getApp1Segment(File jpegFile) throws IOException {
        try (JpegFile jf = null;){
            Segment s;
            jf = new JpegFile(jpegFile);
            for (s = jf.getFirstSegment(); s != null && s.getId() != JpegSegmentType.APP1.byteValue; s = s.getNextSegment()) {
            }
            if (s != null) {
                APP1Segment app1 = new APP1Segment(s);
                byte[] byArray = app1.data;
                return byArray;
            }
            throw new IOException("No APP1 segment found in file " + String.valueOf(jpegFile));
        }
    }

    public static ImageIcon getEmbeddedThumbnail(File jpegFile, int offset, int len) throws IOException {
        byte[] app1Segment = JPEGUtil.getApp1Segment(jpegFile);
        byte[] rawImage = Arrays.copyOfRange(app1Segment, 6 + offset, 6 + offset + len);
        return new ImageIcon(rawImage);
    }
}

