/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.sun.jna.platform.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.jalbum.util.Profiler;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.io.VirtualFile;
import se.datadosen.util.NamedThreadFactory;
import se.datadosen.util.PermissionDeniedException;
import se.datadosen.util.Replacer;
import se.datadosen.util.StringCodec;

public class IO {
    public static final File IMPORT_DIR = new File(System.getProperty("java.io.tmpdir"), "jAlbum-import");
    public static final String CHROME_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36";
    private static final int BUFSIZE = 262144;
    private static boolean preserveLastModified = true;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final ExecutorService workerPool = Executors.newFixedThreadPool(10, new NamedThreadFactory("IO"));
    private static final Pattern backslashPattern = Pattern.compile("\\\\\\\\", 2);
    public static final String rfc3986Reserved = "!*'();@&=+$,?%#[]";
    public static final String reserved = "!*'();@&=+$,?%#[]`\" <>";
    private static Pattern DIACRITICS_PATTERN = Pattern.compile("\\p{M}");
    private static Set systemFiles = new HashSet();

    public static File ensureUnique(File dir, String suggestedName) {
        HashSet<String> existing = new HashSet<String>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                existing.add(f.getName().toLowerCase());
            }
        }
        String base = IO.baseName(suggestedName);
        Object ext = IO.extensionOf(suggestedName);
        if (((String)ext).length() > 0) {
            ext = "." + (String)ext;
        }
        Object name = suggestedName;
        int i = 1;
        while (existing.contains(((String)name).toLowerCase())) {
            name = base + "-" + i + (String)ext;
            ++i;
        }
        return new File(dir, (String)name);
    }

    public static String readTextFile(File file, String encoding) throws IOException, NoSuchFileException, PermissionDeniedException {
        byte[] buf = IO.readBytes(file);
        StringCodec codec = new StringCodec();
        return codec.decode(buf, encoding);
    }

    public static boolean isPreserveLastModified() {
        return preserveLastModified;
    }

    public static void setPreserveLastModified(boolean preserveLastModified) {
        IO.preserveLastModified = preserveLastModified;
    }

    public static String readTextFile(File file) throws IOException, NoSuchFileException, PermissionDeniedException {
        return IO.readTextFile(file, System.getProperty("jalbum.file.encoding"));
    }

    public static String readTextFile(String fileName) throws IOException, NoSuchFileException, PermissionDeniedException {
        return IO.readTextFile(new File(fileName));
    }

    private URL resolveRedirectedURL(URL u) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setInstanceFollowRedirects(false);
        String location = conn.getHeaderField("Location");
        conn.disconnect();
        if (location != null) {
            return new URL(location);
        }
        return u;
    }

    public static String readTextUrl(URL textUrl) throws IOException {
        return IO.readTextUrl(textUrl, null, null);
    }

    public static String readTextUrl(URL textUrl, String userAgent) throws IOException {
        return IO.readTextUrl(textUrl, null, userAgent);
    }

    public static String readTextUrl(URL textUrl, SSLSocketFactory socketFactory) throws IOException {
        return IO.readTextUrl(textUrl, socketFactory, null);
    }

    public static String readTextUrl(URL textUrl, SSLSocketFactory socketFactory, String userAgent) throws IOException {
        URLConnection conn = textUrl.openConnection();
        if (conn != null && conn instanceof HttpsURLConnection && socketFactory != null) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(socketFactory);
        }
        if (userAgent != null) {
            conn.setRequestProperty("User-Agent", userAgent);
        }
        byte[] data = new byte[65536];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (BufferedInputStream is = new BufferedInputStream(conn.getInputStream());){
            int nRead;
            while ((nRead = ((InputStream)is).read(data, 0, data.length)) != -1) {
                bos.write(data, 0, nRead);
            }
        }
        StringCodec codec = new StringCodec();
        return codec.decode(bos.toByteArray(), System.getProperty("jalbum.file.encoding"));
    }

    public static byte[] readBytes(File f) throws IOException, NoSuchFileException, PermissionDeniedException {
        return Files.readAllBytes(f.toPath());
    }

    public static void writeBytes(byte[] buf, File f) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            ((OutputStream)out).write(buf);
        }
    }

    public static void writeTextFile(String content, File file) throws IOException {
        IO.writeTextFile(content, file, System.getProperty("jalbum.file.encoding"));
    }

    public static void writeTextFile(String content, File file, String encoding) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            writer.write(content);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static boolean writeChangedTextFile(String content, File file, String encoding) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            byte[] outBytes = content.getBytes(encoding);
            byte[] inBytes = IO.readBytes(file);
            if (!Arrays.equals(outBytes, inBytes)) {
                IO.writeBytes(outBytes, file);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            IO.writeTextFile(content, file, encoding);
            return true;
        }
    }

    public static Properties readPropertyFile(File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
    }

    public static Map readMapFile(File file) throws IOException {
        return IO.readMapFile(file, false);
    }

    public static Map<String, Object> readMapFile(File file, boolean maintainOrdering) throws IOException {
        return IO.readMap(IO.readBytes(file), maintainOrdering);
    }

    public static Map readMap(byte[] bytes) throws IOException {
        return IO.readMap(bytes, false);
    }

    public static Map<String, Object> readMap(byte[] bytes, boolean maintainOrdering) throws IOException {
        StringCodec codec = new StringCodec();
        String s = codec.decode(bytes, System.getProperty("jalbum.file.encoding"));
        try (BufferedReader in = new BufferedReader(new StringReader(s));){
            String line;
            LinkedHashMap<String, Object> theMap;
            HashMap hashMap = theMap = maintainOrdering ? new LinkedHashMap() : new HashMap();
            while ((line = in.readLine()) != null) {
                int equalsIndex;
                if ((line = line.trim()).startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, equalsIndex).trim();
                String value = line.substring(equalsIndex + 1).trim();
                if (IO.continueLine(line)) {
                    line = value;
                    StringBuilder sb = new StringBuilder();
                    do {
                        sb.append(line, 0, line.length() - 1);
                        line = in.readLine();
                        if (line == null) break;
                        sb.append('\n');
                    } while (IO.continueLine(line));
                    if (line != null) {
                        sb.append(line);
                    }
                    value = sb.toString();
                }
                value = backslashPattern.matcher(value).replaceAll("\\\\");
                theMap.put(key, value);
            }
            LinkedHashMap<String, Object> linkedHashMap = theMap;
            return linkedHashMap;
        }
    }

    public static void writeMapFile(Map map, File f) throws IOException {
        byte[] bytes;
        StringCodec codec;
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        try (PrintWriter out = new PrintWriter(writer);){
            for (Map.Entry e : map.entrySet()) {
                out.println(e.getKey().toString() + "=" + backslashEncoder.replace(e.getValue().toString()));
            }
        }
        String s = writer.getBuffer().toString();
        if (!s.equals((codec = new StringCodec()).decode(bytes = codec.encode(s)))) {
            bytes = codec.encode(s, "UTF-8");
        }
        IO.writeBytes(bytes, f);
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static boolean move(File src, File dest) {
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (src.exists()) {
            dest.delete();
            return src.renameTo(dest);
        }
        return false;
    }

    public static void copyFile(File src, File dest) throws IOException {
        IO.copyFile(src, dest, true);
    }

    public static void copyFile(String name, File dest) throws IOException {
        IO.copyFile(name, dest, true);
    }

    public static void copyFile(String name, File dest, boolean forceCopy) throws IOException {
        IO.copyFile(new File(name), dest, forceCopy);
    }

    public static void copyFile(File src, File dest, boolean forceCopy) throws IOException {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        if (src.isDirectory()) {
            CachedFile[] files;
            if (!dest.isDirectory()) {
                throw new IOException("copyFile: Cannot copy directory " + String.valueOf(src) + " onto single file " + String.valueOf(dest));
            }
            for (CachedFile f : files = CachedFile.listFiles(src)) {
                if (((File)f).isDirectory()) {
                    File newDir = new File(dest, f.getName());
                    newDir.mkdirs();
                    IO.copyFile(f, newDir, forceCopy);
                    continue;
                }
                IO.copyFile(f, dest, forceCopy);
            }
        } else {
            if ("".equals(dest.getName()) && !dest.getParentFile().exists()) {
                dest = dest.getParentFile();
                dest.mkdirs();
            }
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            IO.copyPlainFile(src, dest, forceCopy);
        }
    }

    public static boolean copyFile(File src, File dest, boolean forceCopy, boolean createHardLink) throws IOException {
        if (createHardLink) {
            boolean exists;
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (exists = dest.exists()) {
                if (!forceCopy) {
                    return createHardLink;
                }
                dest.delete();
            }
            try {
                Files.createLink(dest.toPath(), src.toPath());
                if (JAlbum.logger.isLoggable(Level.FINE)) {
                    System.out.println("Created link " + String.valueOf(dest) + " -> " + String.valueOf(LinkFile.targetOf(src)));
                }
                return true;
            }
            catch (IOException | UnsupportedOperationException ex) {
                IO.copyFile(src, dest, forceCopy);
                return false;
            }
        }
        IO.copyFile(src, dest, forceCopy);
        return false;
    }

    private static void classicCopyFile(File src, File dest) throws IOException {
        if (dest.equals(src)) {
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
            int bytesRead;
            byte[] buffer = new byte[262144];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
    }

    private static void nioCopyFile(File src, File dest) throws IOException {
        try (FileInputStream is = new FileInputStream(src);
             FileOutputStream os = new FileOutputStream(dest);
             FileChannel srcChannel = is.getChannel();
             FileChannel dstChannel = os.getChannel();){
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        }
    }

    public static File downloadFile(URL url, File dest) throws PermissionDeniedException, IOException {
        FileOutputStream fos;
        if (dest.isDirectory()) {
            String path;
            String name = path = url.getPath();
            int slashIndex = path.lastIndexOf(47);
            if (slashIndex != -1) {
                name = path.substring(slashIndex + 1);
            }
            dest = new File(dest, name);
        }
        File tmp = new File(dest.getParentFile(), dest.getName() + ".downloading");
        try {
            fos = new FileOutputStream(tmp);
        }
        catch (IOException ex) {
            throw new PermissionDeniedException("Can't write to " + String.valueOf(dest), ex);
        }
        try {
            IO.downloadFile(url, fos);
            fos.close();
            tmp.renameTo(dest);
            return dest;
        }
        catch (IOException ex) {
            tmp.delete();
            throw ex;
        }
    }

    public static void downloadFile(URL url, OutputStream out) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
            if (conn.getResponseCode() != 200) {
                throw new IOException("Error accessing " + String.valueOf(url) + ". Server reported " + conn.getResponseCode() + " " + conn.getResponseMessage());
            }
            BufferedOutputStream bout = new BufferedOutputStream(out);
            byte[] data = new byte[262144];
            int x = 0;
            while ((x = in.read(data, 0, data.length)) >= 0) {
                bout.write(data, 0, x);
            }
            bout.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadZipFile(URL url, File destFolder) throws IOException {
        block10: {
            PipedInputStream pis = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream(pis);
            ExecutorService es = Executors.newSingleThreadExecutor(new NamedThreadFactory("Unzipper"));
            boolean closed = false;
            try {
                Callable<Object> c = () -> {
                    try {
                        IO.downloadFile(url, pos);
                        pos.flush();
                        pos.close();
                        return null;
                    }
                    catch (IOException ex) {
                        pos.close();
                        throw ex;
                    }
                };
                Future<Object> f = es.submit(c);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(pis));
                if (IO.unzip(zis, destFolder, true) > 0) {
                    zis.close();
                    closed = true;
                }
                Object object = f.get();
            }
            catch (InterruptedException c) {
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof IOException) {
                    if (!closed) {
                        throw (IOException)ex.getCause();
                    }
                    break block10;
                }
                throw new RuntimeException(ex.getCause());
            }
            finally {
                es.shutdown();
            }
        }
    }

    public static String readAll(Reader in) throws IOException {
        int bytesRead;
        char[] buffer = new char[262144];
        StringBuilder sb = new StringBuilder();
        while ((bytesRead = in.read(buffer)) != -1) {
            sb.append(buffer, 0, bytesRead);
        }
        return sb.toString();
    }

    public static boolean isSubdirectoryOf(File subdir, File dir) {
        File parent = subdir.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.equals(dir)) {
            return true;
        }
        return IO.isSubdirectoryOf(parent, dir);
    }

    public static void copyDirectoryContent(String srcPath, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(new File(srcPath), dest, forceCopy);
    }

    public static void copyDirectoryContent(File srcDir, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(srcDir, dest, forceCopy, null);
    }

    public static void copyDirectoryContent(File srcDir, File dest, boolean forceCopy, FileFilter filter) throws IOException {
        IO.copyDirectoryContent(srcDir, dest, forceCopy, filter, false);
    }

    public static void copyDirectoryContent(File srcDir, final File dest, final boolean forceCopy, FileFilter filter, final boolean createHardLink) throws IOException {
        dest.mkdirs();
        if (!srcDir.isDirectory()) {
            throw new IOException("Missing directory " + srcDir.getAbsolutePath());
        }
        final File[] files = CachedFile.listFiles(srcDir, filter);
        final TreeMap<String, CachedFile> destMap = CachedFile.map(dest);
        ArrayList<1> tasks = new ArrayList<1>();
        for (int i = 0; i < files.length; ++i) {
            if (((File)files[i]).isDirectory()) continue;
            tasks.add(new IndexedCallable(i){
                {
                    super(index);
                    this.createHardLinks = createHardLink;
                }

                public Object call() throws Exception {
                    File to = (File)destMap.get(files[this.index].getName());
                    if (to == null || to.length() != files[this.index].length()) {
                        to = new VirtualFile(new File(dest, files[this.index].getName()));
                    }
                    this.createHardLinks = IO.copyPlainFile(files[this.index], to, forceCopy, this.createHardLinks);
                    return null;
                }
            });
        }
        try {
            List results = workerPool.invokeAll(tasks);
            for (Future result : results) {
                result.get();
            }
        }
        catch (InterruptedException results) {
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            IO.copyDirectoryContent(file, new File(dest, file.getName()), forceCopy, filter, createHardLink);
        }
    }

    public static void createDirectories(Path path, FileAttribute<?> ... attrs) throws IOException {
        block2: {
            try {
                Files.createDirectories(path, attrs);
            }
            catch (FileAlreadyExistsException ex) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw ex;
            }
        }
    }

    public static String parentPath(String path) {
        int lastSlashIndex;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (lastSlashIndex = path.lastIndexOf(47)) > -1 ? path.substring(0, lastSlashIndex + 1) : "";
    }

    public static String parentOf(String path) {
        int lastSlashIndex;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (lastSlashIndex = path.lastIndexOf(47)) > -1 ? path.substring(0, lastSlashIndex) : "";
    }

    public static String baseName(AlbumObject ao) {
        return ao.isFolder() ? ao.getName() : IO.baseName(ao.getName());
    }

    public static String baseName(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        return dotIndex != -1 ? fullName.substring(0, dotIndex) : fullName;
    }

    public static String ofType(String fullName, String extension) {
        return IO.baseName(fullName) + "." + extension;
    }

    public static String ofType(File file, String extension) {
        return IO.ofType(file.getName(), extension);
    }

    public static File thumbFile(File file) {
        String base;
        File parent = file.getParentFile();
        File thumbFile = new File(parent, (base = IO.baseName(file.getName())) + ".thm");
        if (!thumbFile.exists()) {
            thumbFile = new File(parent, base + ".THM");
        }
        return thumbFile;
    }

    public static boolean isThumbFile(File file) {
        return file.getName().toLowerCase().endsWith(".thm");
    }

    public static String baseName(File file) {
        return IO.baseName(file.getName());
    }

    public static String extensionOf(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1);
    }

    public static String lastPathComponentOf(String path) {
        int slashIndex = path.lastIndexOf(47);
        return slashIndex != -1 ? path.substring(slashIndex + 1) : path;
    }

    public static String extensionOf(File file) {
        return IO.extensionOf(file.getName());
    }

    public static String relativePath(File file, File rel) {
        return IO.relativePath(file.getAbsolutePath(), rel != null ? rel.getAbsolutePath() : "", File.separatorChar);
    }

    public static String relativePath(String fileString, String relString) {
        return IO.relativePath(fileString, relString, '/');
    }

    private static String normalize(String s, char separator) {
        if ("".equals(s)) {
            return "" + separator;
        }
        s = s.charAt(0) == separator ? s : separator + s;
        s = s.charAt(s.length() - 1) == separator ? s : s + separator;
        return s;
    }

    public static String relativePath(String fileString, String relString, char separator) {
        StringTokenizer tokens;
        int i;
        String originalFileString = fileString;
        fileString = IO.normalize(fileString, separator);
        relString = IO.normalize(relString, separator);
        char[] filePath = fileString.toCharArray();
        char[] relPath = relString.toCharArray();
        StringBuilder result = new StringBuilder();
        for (i = 0; i < filePath.length && i < relPath.length && filePath[i] == relPath[i]; ++i) {
        }
        if (i < relPath.length && i < filePath.length || relPath.length < filePath.length && filePath[i] != separator) {
            while (i > 0 && relPath[i - 1] != separator) {
                --i;
            }
        }
        if (i != 0) {
            tokens = new StringTokenizer(relString.substring(i), "" + separator);
            while (tokens.hasMoreTokens()) {
                tokens.nextToken();
                result.append("../");
            }
        }
        if (i > fileString.length()) {
            i = fileString.length();
        }
        if ((tokens = new StringTokenizer(fileString.substring(i), "" + separator)).hasMoreTokens()) {
            result.append(tokens.nextToken());
        } else if (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
        while (tokens.hasMoreTokens()) {
            result.append("/").append(tokens.nextToken());
        }
        String res = result.toString();
        res = res.isEmpty() ? "." : res;
        return res.indexOf(58) != -1 ? originalFileString : res;
    }

    public static String webPath(Path p) {
        return IO.urlEncode(p.toString().replace(File.separatorChar, '/'));
    }

    public static String webPath(Path p, Path rel) {
        try {
            return IO.urlEncode(rel.relativize(p).toString().replace(File.separatorChar, '/'));
        }
        catch (IllegalArgumentException ex) {
            return IO.urlEncode(p.toString().replace(File.separatorChar, '/'));
        }
    }

    public static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException bytes) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || reserved.contains(String.valueOf(chars[i]))) {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String removeDiacritics(String s) {
        return DIACRITICS_PATTERN.matcher(Normalizer.normalize(s, Normalizer.Form.NFKD)).replaceAll("");
    }

    public static String webSafe(String fileName) {
        String ret;
        fileName = fileName.trim();
        String illegal = Config.getConfig().getIllegalCharacters();
        int length = fileName.length();
        char[] chars = null;
        for (int i = 0; i < length; ++i) {
            if (illegal.indexOf(fileName.charAt(i)) == -1) continue;
            if (chars == null) {
                chars = fileName.toCharArray();
            }
            chars[i] = 45;
        }
        String string = ret = chars != null ? new String(chars) : fileName;
        if (!Normalizer.isNormalized(ret, Normalizer.Form.NFC)) {
            ret = Normalizer.normalize(ret, Normalizer.Form.NFC);
        }
        return ret;
    }

    public static boolean isWebSafe(String fileName) {
        return fileName.equals(IO.webSafe(fileName));
    }

    public static File webSafe(File f) {
        String webSafeName = IO.webSafe(f.getName());
        if (!webSafeName.equals(f.getName())) {
            f = new LinkFile(f.getParentFile(), webSafeName, LinkFile.targetOf(f));
        }
        return f;
    }

    public static String combinePaths(String part1, String part2) {
        return IO.combinePaths(part1, part2, '/');
    }

    public static String combinePaths(String part1, String part2, char separator) {
        int start;
        int end;
        if (part1.length() == 0) {
            return part2;
        }
        if (part2.length() == 0) {
            return part1;
        }
        for (end = part1.length(); end > 0 && part1.charAt(end - 1) == separator; --end) {
        }
        if (part1.endsWith("" + separator + separator)) {
            ++end;
        }
        for (start = 0; start < part2.length() && part2.charAt(start) == separator; ++start) {
        }
        return part1.substring(0, end) + separator + part2.substring(start, part2.length());
    }

    public static int sizeof(Object o) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(ba);
            oos.writeObject(o);
            return ba.toByteArray().length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long deepLastModified(File dir) throws IOException {
        long lastModified = dir.lastModified();
        CachedFile[] files = CachedFile.listFiles(dir);
        if (files != null) {
            for (CachedFile file : files) {
                long lm = ((File)file).lastModified();
                if (((File)file).isDirectory()) {
                    lm = IO.deepLastModified(file);
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    public static long deepLastModifiedFile(File dir) throws IOException {
        long lastModified = 0L;
        CachedFile[] files = CachedFile.listFiles(dir);
        if (files != null) {
            for (CachedFile file : files) {
                long lm = ((File)file).lastModified();
                if (((File)file).isDirectory()) {
                    lm = IO.deepLastModifiedFile(file);
                    continue;
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    public static void close(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isSystemFile(String fileName) {
        return systemFiles.contains(fileName);
    }

    public static boolean isEmpty(File dir) {
        File[] content = dir.listFiles();
        if (content != null) {
            return Arrays.asList(content).stream().filter(f -> !systemFiles.contains(f.getName())).count() == 0L;
        }
        return false;
    }

    public static void deleteIfEmpty(File dir) {
        if (IO.isEmpty(dir)) {
            IO.deleteDir(dir);
        }
    }

    public static void deleteDir(File dir) {
        IO.emptyDir(dir);
        dir.delete();
    }

    public static void emptyDir(File dir) {
        final CachedFile[] files = CachedFile.listFiles(dir);
        if (files != null) {
            ArrayList<2> tasks = new ArrayList<2>();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) continue;
                tasks.add(new IndexedCallable(i){

                    public Object call() {
                        files[this.index].delete();
                        return null;
                    }
                });
            }
            try {
                List results = workerPool.invokeAll(tasks);
                for (Future result : results) {
                    result.get();
                }
            }
            catch (InterruptedException results) {
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex.getCause());
            }
            for (CachedFile file : files) {
                if (!file.isDirectory()) continue;
                if (file.isSymbolicLink()) {
                    file.delete();
                    continue;
                }
                IO.deleteDir(file);
            }
        }
    }

    public static boolean recycle(File dir) {
        return IO.recycle(dir, false);
    }

    public static boolean recycle(File dir, boolean recycleOnly) {
        try {
            FileUtils fu = FileUtils.getInstance();
            fu.moveToTrash(new File[]{dir});
            return true;
        }
        catch (Throwable t) {
            if (JAlbum.logger.isLoggable(Level.FINE)) {
                System.err.println("Error moving to recycle bin: " + t.toString());
            }
            if (!recycleOnly) {
                IO.deleteDir(dir);
            }
            return false;
        }
    }

    public static File resolvePath(File f, String path) {
        String[] comps;
        if (path == null) {
            path = "";
        }
        block8: for (String comp : comps = path.split("(/|\\\\)")) {
            if (null == comp) {
                f = new File(f, comp);
                continue;
            }
            switch (comp) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    f = f.getParentFile();
                    continue block8;
                }
                default: {
                    f = new File(f, comp);
                }
            }
        }
        return f;
    }

    public static File zip(File f) throws ZipException, IOException {
        File zipFile = new File(f.getParentFile(), f.getName() + ".zip");
        IO.zip(f, zipFile, null);
        return zipFile;
    }

    public static void zip(File f, File zipFile) throws ZipException, IOException {
        IO.zip(f, zipFile, null);
    }

    public static File zip(File f, FileFilter filter) throws ZipException, IOException, OperationAbortedException {
        File zipFile = new File(f.getParentFile(), f.getName() + ".zip");
        IO.zip(f, zipFile, filter);
        return zipFile;
    }

    public static void zip(File f, File zipFile, FileFilter filter) throws ZipException, IOException, OperationAbortedException {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            if (!f.isDirectory()) {
                IO.writeZipEntry(f.getParentFile(), f, zos);
            } else {
                IO.zipDir(f, f, zos, filter);
            }
        }
        catch (IOException | OperationAbortedException ex) {
            zipFile.delete();
            throw ex;
        }
    }

    private static void zipDir(File root, File dir, ZipOutputStream zos, FileFilter filter) throws ZipException, IOException {
        Object path = root.toPath().relativize(dir.toPath()).toString().replace('\\', '/');
        if (!((String)path).isEmpty()) {
            path = (String)path + "/";
            ZipEntry ze = new ZipEntry((String)path);
            zos.putNextEntry(ze);
        }
        for (File f : dir.listFiles(filter)) {
            if (!f.isDirectory()) {
                IO.writeZipEntry(root, f, zos);
                continue;
            }
            IO.zipDir(root, f, zos, filter);
        }
    }

    private static void writeZipEntry(File root, File f, ZipOutputStream out) throws IOException {
        String path = root.toPath().relativize(f.toPath()).toString().replace('\\', '/');
        ZipEntry ze = new ZipEntry(path);
        ze.setTime(f.lastModified());
        out.putNextEntry(ze);
        try (FileInputStream in = new FileInputStream(f);){
            byte[] b = new byte[32768];
            int bytesRead = 0;
            while (bytesRead >= 0) {
                bytesRead = in.read(b);
                if (bytesRead <= 0) continue;
                out.write(b, 0, bytesRead);
            }
            out.closeEntry();
        }
    }

    public static int unzip(File zipFile, File destDir) throws ZipException, IOException {
        FileInputStream fis = new FileInputStream(zipFile);
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));){
            int n = IO.unzip(zis, destDir, false);
            return n;
        }
    }

    public static int unzip(ZipInputStream zis, File destDir) throws ZipException, IOException {
        return IO.unzip(zis, destDir, false);
    }

    public static int unzip(ZipInputStream zis, File destDir, boolean downloading) throws ZipException, IOException {
        ZipEntry entry;
        int entries = 0;
        BufferedOutputStream dest = null;
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            ++entries;
            byte[] data = new byte[262144];
            File destFile = new File(destDir, entry.getName());
            if (entry.getName().endsWith("/")) {
                destFile.mkdirs();
                continue;
            }
            File tmpFile = destFile;
            if (downloading) {
                tmpFile = new File(destFile.getParentFile(), destFile.getName() + ".downloading");
            }
            FileOutputStream fos = new FileOutputStream(tmpFile);
            dest = new BufferedOutputStream(fos, 262144);
            while ((count = zis.read(data, 0, 262144)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            zis.closeEntry();
            if (!tmpFile.equals(destFile)) {
                tmpFile.renameTo(destFile);
            }
            destFile.setLastModified(entry.getTime());
        }
        return entries;
    }

    public static InputStream openFromZip(File zipFile, String internalPath) throws IOException {
        final ZipFile zip = new ZipFile(zipFile);
        ZipEntry entry = zip.getEntry(internalPath);
        if (entry == null) {
            zip.close();
            throw new FileNotFoundException("Entry not found: " + internalPath);
        }
        InputStream is = zip.getInputStream(entry);
        return new FilterInputStream(is){

            @Override
            public void close() throws IOException {
                super.close();
                zip.close();
            }
        };
    }

    public static TreeSet<Path> listZipEntries(File zipFile, String regexMatch) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry e;
            TreeSet<Path> entries = new TreeSet<Path>();
            while ((e = zin.getNextEntry()) != null) {
                if (!e.getName().matches(regexMatch)) continue;
                entries.add(Path.of(e.getName(), new String[0]));
            }
            TreeSet<Path> treeSet = entries;
            return treeSet;
        }
    }

    private static void copyPlainFile(File src, File dest, boolean forceCopy) throws IOException {
        IO.copyPlainFile(src, dest, forceCopy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean copyPlainFile(File src, File dest, boolean forceCopy, boolean createHardLink) throws IOException {
        if (src.equals(dest)) {
            return createHardLink;
        }
        if (src.getName().equalsIgnoreCase("Thumbs.db")) {
            return createHardLink;
        }
        srcLastModified = src.lastModified();
        destLastModified = 0L;
        if (srcLastModified == 0L && !src.exists()) {
            throw new FileNotFoundException(src.getAbsolutePath());
        }
        if (!forceCopy && srcLastModified <= (destLastModified = dest.lastModified()) && src.length() == dest.length()) {
            return createHardLink;
        }
        dest.delete();
        try {
            if (!createHardLink) ** GOTO lbl23
            try {
                Files.createLink(dest.toPath(), src.toPath());
                var8_6 = true;
                return var8_6;
            }
            catch (IOException ex) {
                createHardLink = false;
lbl23:
                // 2 sources

                if (src.length() > 0x1400000L) {
                    IO.classicCopyFile(src, dest);
                } else {
                    IO.nioCopyFile(src, dest);
                }
            }
        }
        finally {
            if (srcLastModified > 0L) {
                dest.setLastModified(srcLastModified);
            }
        }
        return createHardLink;
    }

    static {
        systemFiles.add(".DS_Store");
        systemFiles.add("desktop.ini");
        systemFiles.add("Thumbs.db");
    }

    private static abstract class IndexedCallable
    implements Callable {
        protected int index;
        protected boolean createHardLinks;

        public IndexedCallable(int index) {
            this.index = index;
        }
    }
}

