/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import net.jalbum.util.Profiler;

public class GraphicsUtilities {
    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        boolean isTranslucent;
        int type = img.getType();
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear && img.getWidth() > targetWidth && img.getHeight() > targetHeight) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public static BufferedImage ensureType(BufferedImage bi, int dstType) {
        if (bi.getType() == dstType) {
            return bi;
        }
        try (Profiler.Sample _s = Profiler.profile("Image type conversion");){
            BufferedImage bi2 = new BufferedImage(bi.getWidth(), bi.getHeight(), dstType);
            Graphics2D g = bi2.createGraphics();
            g.drawImage((Image)bi, 0, 0, null);
            g.dispose();
            BufferedImage bufferedImage = bi2;
            return bufferedImage;
        }
    }

    public static BufferedImage createEmptyImage(Image source) {
        return GraphicsUtilities.createEmptyImage(source.getWidth(null), source.getHeight(null), source);
    }

    public static BufferedImage createEmptyImage(int width, int height, Image source) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            return new BufferedImage(width, height, source instanceof BufferedImage ? ((BufferedImage)source).getType() : 2);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, source instanceof BufferedImage ? ((BufferedImage)source).getTransparency() : 3);
    }

    public static BufferedImage duplicate(Image image) {
        try (Profiler.Sample _s = Profiler.profile("Clone image");){
            BufferedImage bufferedImage = GraphicsUtilities.duplicate3(image);
            return bufferedImage;
        }
    }

    static BufferedImage duplicate1(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        int type = image instanceof BufferedImage ? ((BufferedImage)image).getType() : 2;
        BufferedImage copy = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g = copy.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return copy;
    }

    static BufferedImage duplicate2(BufferedImage sourceImage) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage compatibleImage = gc.createCompatibleImage(sourceImage.getWidth(), sourceImage.getHeight(), sourceImage.getTransparency());
        ColorConvertOp colorConvertOp = new ColorConvertOp(null);
        colorConvertOp.filter(sourceImage, compatibleImage);
        return compatibleImage;
    }

    static BufferedImage duplicate3(Image source) {
        BufferedImage copy = GraphicsUtilities.createEmptyImage(source);
        Graphics2D g = copy.createGraphics();
        g.drawImage(source, 0, 0, null);
        g.dispose();
        return copy;
    }

    static BufferedImage duplicate4(BufferedImage source) {
        BufferedImage clone = new BufferedImage(source.getColorModel(), source.copyData(null), source.isAlphaPremultiplied(), null);
        return clone;
    }

    public static BufferedImage convertToInt(BufferedImage src) {
        if (src.getType() != 1 && src.getType() != 2) {
            BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getTransparency() == 1 ? 1 : 2);
            Graphics2D g = dst.createGraphics();
            g.drawImage((Image)src, 0, 0, null);
            g.dispose();
            return dst;
        }
        return src;
    }

    public static double getHiDPIScale(Component c) {
        GraphicsConfiguration gc = c.getGraphicsConfiguration();
        if (gc == null) {
            return 1.0;
        }
        AffineTransform tx = gc.getDefaultTransform();
        return tx.getScaleX();
    }

    public static Dimension fitWithinBounds(int width, int height, Dimension boundingBox) {
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale + 0.5), (int)((double)height / maxScale + 0.5));
    }
}

