/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.idrsolutions.image.JDeliImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import marcoschmidt.ImageInfo;
import net.jalbum.OutputFormat;
import net.jalbum.avif.AVIFImageWriteParam;
import net.jalbum.avif.Avif;
import net.jalbum.avif.SafeAvif;
import net.jalbum.util.Profiler;
import org.apache.commons.imaging.Imaging;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.GenericRotationSupport;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.io.VirtualFile;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;

public class FileFilters {
    public static final String MEDIA_FILE = "Media file";
    public static final String FLASH_VIDEO = "Flash Video";
    public static final String AUDIO_FILE = "Audio file";
    public static final String WEB_PAGE_TEMPLATE = "Web page template";
    public static final String WEB_LOCATION = "Web Location";
    private static final Set<String> classicTypes = new HashSet<String>();
    private static final Set<String> imageIOTypes = new HashSet<String>();
    private static final Set<String> sanselanTypes = new HashSet<String>();
    private static Map<String, FileType> otherTypes;
    private static final String FOLDER_KEY = "folder";
    private static final int STANDARD_SCALE_MODIFIER = 1;
    private static final int STANDARD_SUBSAMPLING = 1;
    private static String FILETYPES_FILE_NAME;
    private static final Set<String> problematicReaders;

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine) throws IOException {
        FileFilters.saveJPEG(img, file, engine, null);
    }

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData) throws IOException {
        FileFilters.saveJPEG(img, file, engine, metaData, (float)engine.getQualityPercent() / 100.0f);
    }

    public static byte[] saveJPEG(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData, float compressionQuality) throws IOException {
        return FileFilters.saveImage(img, file, file != null ? IO.extensionOf(file).toLowerCase() : "jpeg", engine, metaData, compressionQuality);
    }

    public static byte[] saveImage(BufferedImage img, File file, String formatName, AlbumBean engine, IIOMetadata metaData) throws IOException {
        return FileFilters.saveImage(img, file, OutputFormat.ofExtension(formatName), engine, metaData);
    }

    public static byte[] saveImage(BufferedImage img, File file, OutputFormat format, AlbumBean engine, IIOMetadata metaData) throws IOException {
        float qualityPercent = format.getQualityPercent(engine);
        return FileFilters.saveImage(img, file, format, engine, metaData, qualityPercent / 100.0f);
    }

    private static boolean isLyciadWebPWriter(ImageWriter iw) {
        return "com.luciad.imageio.webp.WebPWriter".equals(iw.getClass().getName());
    }

    public static ImageWriter getCapableWriter(String formatName) {
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(formatName);
        ImageWriter writer = null;
        while (it.hasNext()) {
            writer = it.next();
            if (writer.getClass().getName().equals("it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageWriter")) continue;
            return writer;
        }
        return null;
    }

    public static byte[] saveImage(BufferedImage img, File file, String formatName, AlbumBean engine, IIOMetadata metaData, float compressionQuality) throws IOException {
        return FileFilters.saveImage(img, file, OutputFormat.ofExtension(formatName), engine, metaData, compressionQuality);
    }

    public static byte[] saveImage(BufferedImage img, File file, OutputFormat format, AlbumBean engine, IIOMetadata metaData, float compressionQuality) throws IOException {
        String formatName = format.getExtension();
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(formatName.toLowerCase());
        while (it.hasNext()) {
            ImageWriter iw = it.next();
            try {
                return FileFilters.saveImageWithWriter(img, file, format, engine, metaData, compressionQuality, iw);
            }
            catch (IOException | RuntimeException ex) {
                if (it.hasNext()) {
                    System.err.println("Caught " + String.valueOf(ex) + " writing " + String.valueOf(file) + " using " + String.valueOf(iw));
                    if (!JAlbum.logger.isLoggable(Level.FINE)) continue;
                    ex.printStackTrace(System.err);
                    continue;
                }
                throw ex;
            }
        }
        return null;
    }

    public static byte[] saveImageWithWriter(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData, ImageWriter iw) throws IOException {
        return FileFilters.saveImageWithWriter(img, file, file != null ? OutputFormat.ofExtension(IO.extensionOf(file)) : OutputFormat.JPEG, engine, metaData, (float)engine.getQualityPercent() / 100.0f, iw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] saveImageWithWriter(BufferedImage img, File file, OutputFormat format, AlbumBean engine, IIOMetadata metaData, float compressionQuality, ImageWriter iw) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            boolean hasAlpha;
            if (!(file instanceof VirtualFile) && file != null && file.exists()) {
                file.delete();
            }
            boolean bl = hasAlpha = img.getTransparency() != 1;
            if (format == OutputFormat.JPEG && hasAlpha) {
                BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 4);
                Graphics2D g = bi.createGraphics();
                g.drawImage(img, 0, 0, engine.getImageBackgroundColor(), null);
                g.dispose();
                img = bi;
            }
            if (FileFilters.isLyciadWebPWriter(iw) && img.getRaster().getWritableParent() != null) {
                img = GraphicsUtilities.duplicate(img);
            }
            ImageWriteParam param = iw.getDefaultWriteParam();
            if (format != OutputFormat.PNG) {
                try {
                    param.setCompressionMode(2);
                }
                catch (UnsupportedOperationException ex) {
                    System.err.println(ex.toString());
                }
                if (format == OutputFormat.WEBP) {
                    param.setCompressionType(hasAlpha ? "LOSSLESS" : "LOSSY");
                }
                if (!hasAlpha || format != OutputFormat.WEBP) {
                    param.setCompressionQuality(compressionQuality);
                }
                if (format == OutputFormat.AVIF) {
                    ((AVIFImageWriteParam)param).setSpeed(engine.getSpeedAVIF());
                    ((AVIFImageWriteParam)param).setPreferredCodec(Config.getConfig().getEncoderAVIF());
                }
            }
            ByteArrayOutputStream bos = null;
            ImageOutputStream ios = null;
            try {
                if (!(file instanceof VirtualFile)) {
                    ios = ImageIO.createImageOutputStream(file);
                    if (ios == null) {
                        throw new IOException("Can't write to image file " + file.getAbsolutePath());
                    }
                } else {
                    bos = new ByteArrayOutputStream();
                    ios = ImageIO.createImageOutputStream(bos);
                    if (ios == null) {
                        throw new IOException("Can't write to image to RAM. Format: " + String.valueOf((Object)format));
                    }
                }
                iw.setOutput(ios);
                if (!(param instanceof AVIFImageWriteParam)) {
                    ImageTypeSpecifier type;
                    if (metaData != null) {
                        type = ImageTypeSpecifier.createFromRenderedImage(img);
                        IIOMetadata metaDefault = iw.getDefaultImageMetadata(type, param);
                        Node sofDefault = FileFilters.lookupNode(metaDefault, "sof");
                        FileFilters.replaceSOFMarker(metaData, sofDefault);
                        if (param instanceof JPEGImageWriteParam) {
                            ((JPEGImageWriteParam)param).setOptimizeHuffmanTables(true);
                        }
                    } else if (compressionQuality >= 0.9f && engine.isDisableColorSubsampling()) {
                        JAlbum.logger.finer("Subsampling disabled");
                        type = ImageTypeSpecifier.createFromRenderedImage(img);
                        metaData = iw.getDefaultImageMetadata(type, param);
                        Node sofDefault = FileFilters.lookupNode(metaData, "sof");
                        if (sofDefault != null) {
                            FileFilters.setChromaSubsampling(sofDefault, 1);
                            FileFilters.replaceSOFMarker(metaData, sofDefault);
                        }
                    }
                }
                if (JAlbum.logger.isLoggable(Level.FINE)) {
                    System.out.println("Saving " + String.valueOf(file) + " using " + String.valueOf(iw));
                }
                iw.write(null, new IIOImage(img, null, metaData), param);
                if (JAlbum.logger.isLoggable(Level.FINE)) {
                    // empty if block
                }
            }
            finally {
                iw.dispose();
                IO.close(ios);
            }
            byte[] byArray = bos != null ? bos.toByteArray() : null;
            return byArray;
        }
    }

    public static boolean isJPEGImage(File f) {
        String name = f.getName().toLowerCase();
        return name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    public static boolean isAVIFImage(File f) {
        String name = f.getName().toLowerCase();
        return name.endsWith(".avif");
    }

    public static IIOMetadata getMetaData(File file) throws IOException {
        IIOMetadata meta = null;
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Profiler.Sample _s = Profiler.profile();
            try {
                Iterator<ImageReader> it = FileFilters.getImageReaders(IO.extensionOf(file), iis);
                while (it.hasNext()) {
                    ImageReader ir = it.next();
                    if (problematicReaders.contains(ir.getClass().getName())) continue;
                    ir.setInput(iis);
                    try {
                        meta = ir.getImageMetadata(ir.getMinIndex());
                        break;
                    }
                    catch (IOException ex) {
                        if (ex.getMessage() == null || !ex.getMessage().endsWith("without prior JFIF!")) break;
                        try (ImageInputStream iis2 = ImageIO.createImageInputStream(new PatchInputStream(new BufferedInputStream(new FileInputStream(file))));){
                            ir.setInput(iis2);
                            meta = ir.getImageMetadata(ir.getMinIndex());
                            break;
                        }
                    }
                }
                IIOMetadata iIOMetadata = meta;
                if (_s != null) {
                    _s.close();
                }
                return iIOMetadata;
            }
            catch (Throwable throwable) {
                if (_s != null) {
                    try {
                        _s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static boolean isFileSupported(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileFilters.getExtensionOf(file);
        return classicTypes.contains(extension) || imageIOTypes.contains(extension) || sanselanTypes.contains(extension);
    }

    @Deprecated
    public static boolean isMediaFile(File file) {
        boolean mediaFile = FileFilters.hasIcon(file);
        if (file.isDirectory()) {
            return false;
        }
        return mediaFile;
    }

    public static String getFileCategory(File f) {
        FileType type = (FileType)FileFilters.getOtherTypes().get(FileFilters.getExtensionOf(f));
        if (type != null) {
            return type.name;
        }
        return null;
    }

    public static FileType getFileType(File f) {
        return (FileType)FileFilters.getOtherTypes().get(FileFilters.getExtensionOf(f));
    }

    public static boolean hasIcon(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (FileFilters.isFileSupported(file)) {
            return false;
        }
        String ext = FileFilters.getExtensionOf(file);
        return FileFilters.getOtherTypes().containsKey(ext) || VideoProcessor.createInstance(null).isFormatSupported(ext);
    }

    @Deprecated
    public static File getIconFor(File f) {
        return FileFilters.getIconFor(f, null);
    }

    public static File getIconFor(File f, AlbumBean engine) {
        Config c = Config.getConfig();
        String ext = f.isDirectory() ? FOLDER_KEY : FileFilters.getExtensionOf(f);
        FileType ft = (FileType)FileFilters.getOtherTypes().get(ext);
        if (ft == null || ft.icon == null) {
            return null;
        }
        if (engine != null) {
            File skinDir = engine.skinDir;
            File stylesDir = new File(skinDir, "styles");
            File styleDir = new File(stylesDir, IO.baseName(engine.getStyle()));
            File iconFile = new File(styleDir, ft.icon);
            if (iconFile.exists()) {
                return iconFile;
            }
            iconFile = new File(engine.srcResDir, ft.icon);
            if (iconFile.exists()) {
                return iconFile;
            }
        }
        return new File(c.progDir, "res/" + ft.icon);
    }

    @Deprecated
    public static String getExtensionOf(File f) {
        if (f == null) {
            throw new RuntimeException("File can't be null!");
        }
        String name = f.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1).toLowerCase();
    }

    private static void fixDHTNode(Node root) {
        Node lastChild = root.getLastChild();
        NodeList nl = lastChild.getChildNodes();
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals("dht")) continue;
            Node dht = n;
            NodeList dhtables = dht.getChildNodes();
            if (dhtables.getLength() < 1) {
                dht.getParentNode().removeChild(dht);
                continue;
            }
            while (dhtables.getLength() > 4) {
                dht.removeChild(dhtables.item(4));
            }
        }
    }

    private static ImageInfo getImageInfo(File file) throws IOException {
        ImageInfo ii = new ImageInfo();
        try (FileInputStream fis = new FileInputStream(file);){
            ii.setCollectComments(false);
            ii.setInput(fis);
            if (!ii.check()) {
                throw new IOException(Msg.get("engine.unsupportedFileFormatError") + file.getName());
            }
        }
        return ii;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static BasicImageInfo getBasicImageInfo(File f) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            BasicImageInfo info = new BasicImageInfo();
            String ext = IO.extensionOf(f).toLowerCase();
            if ("thm".equals(ext)) {
                ext = "jpg";
            }
            if (ext.equals("avif") && SafeAvif.isInitiatedOk()) {
                net.jalbum.avif.ImageInfo ii = new net.jalbum.avif.ImageInfo();
                Avif.read((File)f, (net.jalbum.avif.ImageInfo)ii, null);
                boolean rotated = ii.angle == 1 || ii.angle == 3;
                info.width = rotated ? ii.height : ii.width;
                info.height = rotated ? ii.width : ii.height;
                info.formatName = ext;
                BasicImageInfo basicImageInfo = info;
                return basicImageInfo;
            }
            if (ext.equals("gif")) {
                ImageInfo ii = FileFilters.getImageInfo(f);
                info.width = ii.getWidth();
                info.height = ii.getHeight();
                info.formatName = ii.getFormatName();
                BasicImageInfo rotated = info;
                return rotated;
            }
            if (sanselanTypes.contains(ext)) {
                org.apache.commons.imaging.ImageInfo sImageInfo = Imaging.getImageInfo((File)f);
                if (sImageInfo == null) {
                    throw new IOException("Unsupported file format for " + String.valueOf(f));
                }
                info.width = sImageInfo.getWidth();
                info.height = sImageInfo.getHeight();
                info.formatName = sImageInfo.getFormatName();
                BasicImageInfo rotated = info;
                return rotated;
            }
            try (FileImageInputStream iis = new FileImageInputStream(f);){
                Iterator<ImageReader> it = FileFilters.getImageReaders(IO.extensionOf(f), iis);
                ImageReader reader = null;
                while (it.hasNext()) {
                    try {
                        reader = it.next();
                        if ("net.jalbum.jlibraw.LibRawImageReader".equals(reader.getClass().getName())) {
                            info.setRaw(true);
                        }
                        if ("org.monte.media.jpeg.CMYKJPEGImageReader".equals(reader.getClass().getName()) || "it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReader".equals(reader.getClass().getName())) continue;
                        if (JAlbum.logger.isLoggable(Level.FINER)) {
                            System.out.println("Reading metadata using " + String.valueOf(reader.getClass()));
                        }
                        reader.setInput(iis, true, true);
                        int minIndex = reader.getMinIndex();
                        info.width = reader.getWidth(minIndex);
                        info.height = reader.getHeight(minIndex);
                        info.formatName = reader.getFormatName();
                        reader.dispose();
                        BasicImageInfo basicImageInfo = info;
                        return basicImageInfo;
                    }
                    catch (RuntimeException ex) {
                        System.err.println(ex.getMessage());
                        if (it.hasNext()) continue;
                        throw new IOException("Error reading file info for " + String.valueOf(f) + " using " + String.valueOf(reader), ex);
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unexpected error processing " + String.valueOf(f), ex);
        }
    }

    @Deprecated
    public static BufferedImage loadImage(File file, AlbumBean engine) throws IOException {
        if (!FileFilters.getExtensionOf(file).equals("thm") && !FileFilters.isFileSupported(file)) {
            file = FileFilters.getIconFor(file, engine);
        }
        return FileFilters.loadImage(file, 1);
    }

    public static BufferedImage loadImage(File file) throws IOException {
        return FileFilters.loadImage(file, 1);
    }

    public static Iterator<ImageReader> getImageReaders(String fileSuffix, Object input) {
        ArrayList<ImageReader> readers = new ArrayList<ImageReader>();
        Iterator<ImageReader> it = null;
        if (fileSuffix.length() > 0) {
            it = ImageIO.getImageReadersBySuffix(fileSuffix);
        }
        if (!(it != null && it.hasNext() || input == null)) {
            it = ImageIO.getImageReaders(input);
        }
        if (it != null) {
            while (it.hasNext()) {
                ImageReader r = it.next();
                readers.add(r);
            }
        }
        return readers.iterator();
    }

    public static BufferedImage loadImage(File file, int subsampling) throws IOException {
        return FileFilters.loadImage(file, subsampling, null, new ReaderFlag[0]);
    }

    public static BufferedImage fastLoadImage(File f, Dimension bounds) throws IOException {
        int subsampling = FileFilters.calculateSubsamplingByScale(FileFilters.getBasicImageInfo(f), bounds);
        BufferedImage im = FileFilters.loadImage(f, subsampling);
        im = GenericRotationSupport.adjustOrientation(im, f);
        Dimension newSize = GraphicsUtilities.fitWithinBounds(im.getWidth(), im.getHeight(), bounds);
        im = GraphicsUtilities.getFasterScaledInstance(im, newSize.width, newSize.height, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
        return im;
    }

    public static BufferedImage loadImage(File file, int subsampling, ImageReadParam param, ReaderFlag ... flags) throws IOException {
        BufferedImage im = FileFilters.doLoadImage(file, subsampling, param, flags);
        if (im.getType() == 0) {
            im = FileFilters.ensureHardwareManagedImage(im);
        }
        return im;
    }

    static BufferedImage unifyColorModel(BufferedImage img) {
        try (Profiler.Sample _s = Profiler.profile();){
            int iw = img.getWidth();
            int ih = img.getHeight();
            int newType = img.getTransparency() == 1 ? 1 : 2;
            BufferedImage bi = new BufferedImage(iw, ih, newType);
            Graphics2D g = bi.createGraphics();
            if (Platform.isMac()) {
                g.drawImage(img, 0, 0, iw, ih + 1, null);
            } else {
                g.drawImage((Image)img, 0, 0, null);
            }
            img.flush();
            g.dispose();
            BufferedImage bufferedImage = bi;
            return bufferedImage;
        }
    }

    public static BufferedImage ensureHardwareManagedImage(BufferedImage sourceImage) {
        try (Profiler.Sample _s = Profiler.profile();){
            int requiredType;
            int n = requiredType = 3 == sourceImage.getTransparency() ? 2 : 1;
            if (sourceImage.getType() == requiredType) {
                BufferedImage bufferedImage = sourceImage;
                return bufferedImage;
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            BufferedImage compatibleImage = gc.createCompatibleImage(sourceImage.getWidth(), sourceImage.getHeight(), sourceImage.getTransparency());
            ColorConvertOp colorConvertOp = new ColorConvertOp(null);
            colorConvertOp.filter(sourceImage, compatibleImage);
            BufferedImage bufferedImage = compatibleImage;
            return bufferedImage;
        }
    }

    /*
     * Exception decompiling
     */
    private static BufferedImage doLoadImage(File file, int subsampling, ImageReadParam param, ReaderFlag ... moreFlags) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int calculateSubsamplingByScale(BasicImageInfo info, Dimension imageDim) {
        return FileFilters.calculateSubsamplingByScale(info, imageDim, 1);
    }

    public static int calculateSubsamplingByScale(BasicImageInfo info, Dimension imageDim, int scaleModifier) {
        if (System.getProperty("subsampling") != null) {
            return Integer.parseInt(System.getProperty("subsampling"));
        }
        int scale = Math.min(info.width / imageDim.width, info.height / imageDim.height);
        if (info.width * info.height < 0x3200000) {
            scale -= scaleModifier;
        }
        if (scale < 1) {
            scale = 1;
        }
        return scale;
    }

    private static void readFileTypesInto(File fileTypesFile, Map<String, FileType> types) {
        try {
            Element type;
            if (!fileTypesFile.exists()) {
                return;
            }
            String content = IO.readTextFile(fileTypesFile);
            String docrest = content = Elements.stripComments(content);
            Element root = Elements.getElementByName("filetypes", docrest, false);
            if (root != null) {
                otherTypes.put(FOLDER_KEY, new FileType("Folder", root.getAttribute("foldericon", "folder.png"), null));
            }
            while ((type = Elements.getElementByName("type", docrest, false)) != null) {
                Element ext;
                FileType ft = new FileType(type.getAttribute("name"), type.getAttribute("icon"), type.getAttribute("mimeType"));
                String extrest = type.getContent().toString();
                while ((ext = Elements.getElementByName("ext", extrest, false)) != null) {
                    otherTypes.put(ext.getContent().toString(), ft);
                    extrest = ext.getPostElement().toString();
                }
                docrest = type.getPostElement().toString();
            }
        }
        catch (IOException | ElementException ex) {
            ex.printStackTrace(System.err);
        }
    }

    static Map getOtherTypes() {
        if (otherTypes != null) {
            return otherTypes;
        }
        otherTypes = new HashMap<String, FileType>();
        Config c = Config.getConfig();
        FileFilters.readFileTypesInto(new File(c.chainedSystemDir.getBackgroundDirectory(), FILETYPES_FILE_NAME), otherTypes);
        FileFilters.readFileTypesInto(new File(c.chainedSystemDir.getDirectory(), FILETYPES_FILE_NAME), otherTypes);
        return otherTypes;
    }

    private static void setChromaSubsampling(Node sofNode, int subsampling) {
        if (sofNode.getChildNodes().getLength() == 3) {
            Node vSamplingFactor;
            Node n = sofNode.getFirstChild();
            NamedNodeMap attrs = n.getAttributes();
            Node hSamplingFactor = attrs.getNamedItem("HsamplingFactor");
            if (hSamplingFactor != null) {
                hSamplingFactor.setNodeValue("" + subsampling);
            }
            if ((vSamplingFactor = attrs.getNamedItem("VsamplingFactor")) != null) {
                vSamplingFactor.setNodeValue("" + subsampling);
            }
        }
    }

    private static boolean replaceSOFMarker(IIOMetadata meta, Node sof) throws IIOInvalidTreeException {
        try {
            String format = meta.getNativeMetadataFormatName();
            Node root = meta.getAsTree(format);
            Node backup = meta.getAsTree(format);
            try {
                Node markerSequence = FileFilters.lookupNode(root, "markerSequence");
                if (markerSequence == null) {
                    return false;
                }
                Node sofOld = FileFilters.lookupNode(markerSequence, "sof");
                if (sofOld != null) {
                    markerSequence.removeChild(sofOld);
                }
                markerSequence.appendChild(sof);
                FileFilters.fixDHTNode(root);
                meta.setFromTree(format, root);
            }
            catch (RuntimeException | IIOInvalidTreeException e) {
                FileFilters.fixDHTNode(backup);
                meta.setFromTree(format, backup);
                return false;
            }
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
        return true;
    }

    private static Node lookupNode(IIOMetadata meta, String name) {
        if (meta == null) {
            return null;
        }
        String format = meta.getNativeMetadataFormatName();
        Node root = meta.getAsTree(format);
        return FileFilters.lookupNode(root, name);
    }

    private static Node lookupNode(Node n, String name) {
        if (n == null) {
            return null;
        }
        if (name.equals(n.getNodeName())) {
            return n;
        }
        Node res = FileFilters.lookupNode(n.getFirstChild(), name);
        if (res != null) {
            return res;
        }
        return FileFilters.lookupNode(n.getNextSibling(), name);
    }

    public static void reorderImageReaders() {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<ImageReaderSpi> providers = registry.getServiceProviders(ImageReaderSpi.class, new JPEGFilter(), true);
        ImageReaderSpi standardJPEGReaderSPI = null;
        ImageReaderSpi cmykJPEGReaderSPI = null;
        while (providers.hasNext()) {
            ImageReaderSpi readerSPI = providers.next();
            if (readerSPI.getPluginClassName().equals("org.monte.media.jpeg.CMYKJPEGImageReader")) {
                cmykJPEGReaderSPI = readerSPI;
                continue;
            }
            standardJPEGReaderSPI = readerSPI;
        }
        if (standardJPEGReaderSPI != null && cmykJPEGReaderSPI != null) {
            boolean unsetResult = registry.unsetOrdering(ImageReaderSpi.class, cmykJPEGReaderSPI, standardJPEGReaderSPI);
            boolean bl = registry.setOrdering(ImageReaderSpi.class, standardJPEGReaderSPI, cmykJPEGReaderSPI);
        }
        try {
            registry.setOrdering(ImageReaderSpi.class, (ImageReaderSpi)registry.getServiceProviderByClass(Class.forName("com.luciad.imageio.webp.WebPImageReaderSpi")), (ImageReaderSpi)registry.getServiceProviderByClass(Class.forName("com.idrsolutions.imageio.plugin.jdeli.WEBPImageReaderSpi")));
            registry.setOrdering(ImageWriterSpi.class, (ImageWriterSpi)registry.getServiceProviderByClass(Class.forName("com.luciad.imageio.webp.WebPImageWriterSpi")), (ImageWriterSpi)registry.getServiceProviderByClass(Class.forName("com.idrsolutions.imageio.plugin.jdeli.WEBPImageWriterSpi")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$doLoadImage$0(File file, Exception ex) {
        System.err.println("For image: " + file.getAbsolutePath());
        ex.printStackTrace(System.err);
    }

    static {
        FILETYPES_FILE_NAME = "filetypes.xml";
        problematicReaders = new HashSet<String>();
        problematicReaders.add("com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader");
        problematicReaders.add("it.geosolutions.imageio.plugins.turbojpeg.TurboJpegImageReader");
        try {
            JDeliImage.version = "JAlbum-2022";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        classicTypes.add("jpg");
        classicTypes.add("jpeg");
        classicTypes.add("jpe");
        classicTypes.add("gif");
        classicTypes.add("png");
        String[] types = ImageIO.getReaderFileSuffixes();
        imageIOTypes.addAll(Arrays.asList(types));
        imageIOTypes.add("mpo");
        sanselanTypes.add("pnm");
        sanselanTypes.add("pgm");
        sanselanTypes.add("pbm");
        sanselanTypes.add("ppm");
        FileFilters.reorderImageReaders();
    }

    private static class PatchInputStream
    extends FilterInputStream {
        private static final int[] JFIF = new int[]{255, 224, 0, 16, 74, 70, 73, 70, 0, 1, 2, 0, 0, 1, 0, 1, 0, 0};
        int position = 0;

        public PatchInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = this.position < 2 ? this.in.read() : (this.position < 2 + JFIF.length ? JFIF[this.position - 2] : this.in.read());
            ++this.position;
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int max = off + len;
            int bytesread = 0;
            for (int i = off; i < max; ++i) {
                int bi = this.read();
                if (bi == -1) {
                    if (bytesread != 0) break;
                    bytesread = -1;
                    break;
                }
                b[i] = (byte)bi;
                ++bytesread;
            }
            return bytesread;
        }
    }

    public static class FileType {
        public String name;
        public String icon;
        public String mimeType;

        public FileType(String name, String iconName, String mimeType) {
            this.name = name;
            this.icon = iconName;
            this.mimeType = mimeType;
        }

        public String toString() {
            return "{Name=" + this.name + " icon=" + this.icon + " mimeType=" + this.mimeType + "}";
        }
    }

    public static class BasicImageInfo {
        public int width;
        public int height;
        public String formatName;
        private boolean raw;

        public Dimension getSize() {
            return new Dimension(this.width, this.height);
        }

        public boolean isRaw() {
            return this.raw;
        }

        public void setRaw(boolean raw) {
            this.raw = raw;
        }

        public String toString() {
            return "BasicImageInfo{width=" + this.width + ", height=" + this.height + ", formatName=" + this.formatName + ", raw=" + this.raw + "}";
        }
    }

    public static enum ReaderFlag {
        DONT_APPLY_COLOR_PROFILE;

    }

    private static class JPEGFilter
    implements ServiceRegistry.Filter {
        private JPEGFilter() {
        }

        @Override
        public boolean filter(Object provider) {
            String[] formatNames;
            if (!(provider instanceof ImageReaderSpi)) {
                return false;
            }
            ImageReaderSpi readerSPI = (ImageReaderSpi)provider;
            for (String formatName : formatNames = readerSPI.getFormatNames()) {
                if (!formatName.equalsIgnoreCase("JPEG")) continue;
                return true;
            }
            return false;
        }
    }
}

