/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JErrorDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;

public class Debug {
    public static void showErrorDialog(Component parent, Throwable t) {
        Debug.showErrorDialog(parent, t.toString(), t);
    }

    public static void showFriendlyErrorDialog(Component parent, Throwable t) {
        Debug.showErrorDialog(parent, t.getMessage().length() > 0 ? t.getMessage() : t.toString(), t);
    }

    public static void showErrorDialog(Component parent, String message, Throwable t) {
        if (parent == null) {
            parent = JAlbumContext.getInstance().getFrame();
        }
        if (Config.getConfig().isDebugMode()) {
            Debug.showStackTraceDialog(parent, t);
        } else {
            Tracer.getInstance().trace("crash", t, new String[0]);
            JErrorDialog ed = new JErrorDialog(parent, message, t);
            ed.setVisible(true);
        }
    }

    public static void showExpandableErrorDialog(Component parent, String message, String detailMessage, String title) {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(14, 10, 0, 10));
        JLabel label = new JLabel(message);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        content.add((Component)label, "North");
        JCollapsiblePanel cp = new JCollapsiblePanel(Msg.get("ui.moreInfo"), new BorderLayout());
        cp.addPropertyChangeListener("expanded", pce -> SwingUtilities.getWindowAncestor(cp).pack());
        JLabel detailMessageLabel = new JLabel(detailMessage);
        detailMessageLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        cp.add(detailMessageLabel);
        content.add((Component)cp, "Center");
        JOptionPane.showMessageDialog(null, content, title, 0);
    }

    public static void showStackTraceDialog(Component parent, Throwable t) {
        t.printStackTrace(System.out);
        Tracer.getInstance().trace("crash", t, new String[0]);
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        try (PrintWriter err = new PrintWriter(sw);){
            err.println("An unexpected error occurred. Please see detailed description below:");
            err.println("");
            t.printStackTrace(err);
        }
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        sp.getViewport().add((Component)ta, null);
        JCopyableOptionPane.showCopyableMessageDialog(parent, sp, sw.toString(), Msg.get("ui.unexpectedErrorOccured"), 0);
    }

    public static void showCopyableError(Component parent, Throwable t, String title) {
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        try (PrintWriter err = new PrintWriter(sw);){
            err.println(t.getMessage());
        }
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setColumns(80);
        ta.setRows(15);
        sp.getViewport().add((Component)ta, null);
        JCopyableOptionPane.showCopyableMessageDialog(parent, sp, sw.toString(), Msg.get("ui.unexpectedErrorOccured"), 0);
    }

    public static void printClassInfo(Class c) {
        System.out.println("Class info:");
        do {
            System.out.println(c.getName() + " Loader: " + String.valueOf(c.getClassLoader()));
        } while ((c = c.getSuperclass()) != null);
    }

    public static void log(String s) {
        if (Config.getConfig().isDebugMode()) {
            System.out.println(s);
        }
    }

    public static void logErr(String s) {
        if (Config.getConfig().isDebugMode()) {
            System.err.println(s);
        }
    }

    public static void logErr(Object o) {
        if (Config.getConfig().isDebugMode()) {
            System.err.println(o);
        }
    }

    private static class JCopyableOptionPane {
        private String stringMessage;
        private JButton copyButton = new JButton(Msg.get("ui.copyToClipboard"));
        private JButton okButton = new JButton(Msg.get("ok"));
        private JDialog dialog;

        public static void showCopyableMessageDialog(Component parentComponent, Object message, String stringMessage, String title, int messageType) throws HeadlessException {
            JCopyableOptionPane pane = new JCopyableOptionPane(parentComponent, message, stringMessage, title, messageType);
            pane.dialog.setVisible(true);
            pane.dialog.dispose();
        }

        private JCopyableOptionPane(Component parentComponent, Object message, String stringMessage, String title, int messageType) {
            this.stringMessage = stringMessage;
            this.copyButton.addActionListener(e -> {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(this.stringMessage), null);
            });
            this.okButton.addActionListener(e -> this.dialog.setVisible(false));
            JOptionPane pane = new JOptionPane(message, messageType, messageType, null, new Object[]{this.copyButton, this.okButton}, this.okButton);
            this.dialog = pane.createDialog(parentComponent, title);
            this.dialog.setResizable(true);
        }
    }
}

