/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import se.datadosen.imaging.exif.ImageInfoFormatter;

public class Dates {
    private Dates() {
    }

    public static Date now() {
        return new Date();
    }

    public static String format(Date date) {
        return Dates.format(date, null);
    }

    public static String format(long date) {
        return Dates.format(new Date(date), null);
    }

    public static String format(String dateString) {
        return Dates.format(dateString, null);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat df = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern) : new SimpleDateFormat();
        return df.format(date);
    }

    public static String format(long date, String pattern) {
        return Dates.format(new Date(date), pattern);
    }

    public static String format(String dateString, String pattern) {
        return Dates.format(ImageInfoFormatter.parseExifDate(dateString), pattern);
    }

    public static Date toDate(String dateString) {
        return ImageInfoFormatter.parseExifDate(dateString);
    }

    public static Date toDate(long dateMillis) {
        return new Date(dateMillis);
    }

    public static int dateDiff(char unit, Date testDate, Date refDate) throws IllegalArgumentException {
        long testDateMillis = testDate.getTime();
        long refDateMillis = refDate.getTime();
        if ((unit = Character.toUpperCase(unit)) != 'D') {
            throw new IllegalArgumentException("Invalid date unit specified. Currently only 'D' (days) allowed");
        }
        return (int)((testDateMillis - refDateMillis) / 1000L / 60L / 60L / 24L);
    }

    public static int dateDiff(char unit, String testDate, Date refDate) throws IllegalArgumentException {
        return Dates.dateDiff(unit, Dates.toDate(testDate), refDate);
    }

    public static int dateDiff(char unit, Date testDate, String refDate) throws IllegalArgumentException {
        return Dates.dateDiff(unit, testDate, Dates.toDate(refDate));
    }

    public static int dateDiff(char unit, String testDate, String refDate) throws IllegalArgumentException {
        return Dates.dateDiff(unit, Dates.toDate(testDate), Dates.toDate(refDate));
    }

    public static String stripTime(String pattern) {
        int hourIndex;
        if (pattern == null || pattern.length() == 0) {
            pattern = new SimpleDateFormat().toPattern();
        }
        if ((hourIndex = pattern.toLowerCase().indexOf("h")) != -1) {
            int i;
            for (i = hourIndex - 1; i >= 0 && !Character.isAlphabetic(pattern.charAt(i)); --i) {
            }
            return pattern.substring(0, i + 1);
        }
        return pattern;
    }
}

