/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import net.jalbum.util.Parameters;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Colors;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.Bean;
import se.datadosen.util.annotations.CallOrder;
import se.datadosen.util.annotations.Unbound;

public class BeanBinderBase {
    public static void setProperties(Object bean, Map props) throws BeanBinderException {
        Method[] methods;
        Class<?> beanClass = bean.getClass();
        for (Method method : methods = BeanBinderBase.orderByCallOrder(beanClass.getMethods())) {
            String metName = method.getName();
            if (!metName.startsWith("set") || method.isAnnotationPresent(Unbound.class)) continue;
            String property = BeanBinderBase.lowerInitial(metName.substring(3));
            String sval = "";
            try {
                Class<?>[] types;
                if (method.isAnnotationPresent(Bean.class)) {
                    Properties prefixed = BeanBinderBase.getPrefixedVariables(props, property + ".");
                    if (prefixed.isEmpty()) continue;
                    Method getter = beanClass.getMethod("get" + BeanBinderBase.upperInitial(property), new Class[0]);
                    Object b = getter.invoke(bean, new Object[0]);
                    BeanBinderBase.setProperties(b, prefixed);
                    method.invoke(bean, b);
                    continue;
                }
                Object val = props.get(property);
                String string = sval = val != null ? val.toString() : null;
                if (sval == null) {
                    val = props.get(metName.substring(3));
                    String string2 = sval = val != null ? val.toString() : null;
                }
                if (sval == null || (types = method.getParameterTypes()).length != 1) continue;
                Class<?> type = types[0];
                val = null;
                if (type.equals(String.class)) {
                    val = sval;
                } else if (type.equals(Boolean.TYPE)) {
                    val = !sval.equals("false");
                } else if (type.equals(Integer.TYPE)) {
                    val = Integer.valueOf(sval);
                } else if (type.equals(Float.TYPE)) {
                    val = Float.valueOf(sval);
                } else if (type.equals(Double.TYPE)) {
                    val = Double.valueOf(sval);
                } else if (type.equals(List.class)) {
                    LinkedList<String> list = new LinkedList<String>();
                    StringTokenizer tokens = new StringTokenizer(sval, ",");
                    while (tokens.hasMoreElements()) {
                        list.add(tokens.nextToken());
                    }
                    val = list;
                } else if (type.equals(Color.class)) {
                    val = Colors.getHTMLColor(sval);
                } else if (type.isEnum()) {
                    val = Enum.valueOf(type, sval);
                } else if (Parameters.class.isAssignableFrom(type)) {
                    val = StringUtil.stringToParameters(sval);
                } else if (Map.class.isAssignableFrom(type)) {
                    val = StringUtil.stringToMap(sval);
                } else if (Set.class.isAssignableFrom(type)) {
                    val = StringUtil.stringToSet(sval);
                }
                if (val == null) continue;
                method.invoke(bean, val);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | BeanBinderException ex) {
                if (!JAlbum.logger.isLoggable(Level.FINE)) continue;
                System.err.println("Invalid value for property " + property + ": " + sval);
            }
        }
    }

    protected static Method[] orderByCallOrder(Method[] methods) {
        Arrays.sort(methods, (m1, m2) -> {
            CallOrder co1 = m1.getAnnotation(CallOrder.class);
            CallOrder co2 = m2.getAnnotation(CallOrder.class);
            int callOrder1 = co1 != null ? co1.value() : 10;
            int callOrder2 = co2 != null ? co2.value() : 10;
            return callOrder1 - callOrder2;
        });
        return methods;
    }

    protected static String propertyName(String metName) {
        return metName.startsWith("get") ? BeanBinderBase.lowerInitial(metName.substring(3)) : BeanBinderBase.lowerInitial(metName.substring(2));
    }

    protected static String lowerInitial(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    protected static String upperInitial(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    protected static Properties getPrefixedVariables(Map<String, Object> props, String prefix) {
        Properties theMap = new Properties();
        for (Map.Entry<String, Object> item : props.entrySet()) {
            String name = item.getKey();
            if (!name.startsWith(prefix)) continue;
            theMap.put(name.substring(prefix.length()), item.getValue().toString());
        }
        return theMap;
    }

    public static Properties parseArgsOptions(String[] args) {
        Properties props = new Properties();
        String name = null;
        int i = 0;
        while (i < args.length) {
            if (name == null) {
                if (args[i].charAt(0) == '-') {
                    name = args[i].substring(1);
                }
                ++i;
                continue;
            }
            if (args[i].charAt(0) == '-') {
                props.put(name, "");
            } else {
                props.put(name, args[i]);
                ++i;
            }
            name = null;
        }
        if (name != null) {
            props.put(name, "");
        }
        return props;
    }
}

