/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Color;
import java.awt.Container;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import net.jalbum.util.Parameters;
import se.datadosen.component.JColorSelector;
import se.datadosen.util.BeanBinderBase;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.BinderListener;
import se.datadosen.util.Colors;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.PersistentChoice;
import se.datadosen.util.PersistentList;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.Bean;
import se.datadosen.util.annotations.IgnoreRead;
import se.datadosen.util.annotations.Unbound;

public class BeanBinder
extends BeanBinderBase {
    private List<BinderListener> listeners;
    private List<Container> uis = new ArrayList<Container>();
    private static final ThreadLocal<Boolean> synchingUI = new ThreadLocal();

    private static void revertComponentValue(Object comp, Object bean, String propName) {
    }

    public void onRead(final Runnable r) {
        this.addBinderListener(new BinderListener(){
            final /* synthetic */ BeanBinder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void writeModel() {
            }

            @Override
            public void modelRead() {
                r.run();
            }
        });
    }

    public void onWrite(final Runnable r) {
        this.addBinderListener(new BinderListener(){
            final /* synthetic */ BeanBinder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void writeModel() {
                r.run();
            }

            @Override
            public void modelRead() {
            }
        });
    }

    public static Object cloneProperties(Object fromBean, Object toBean) throws BeanBinderException {
        try {
            BeanBinder.setProperties(toBean, BeanBinder.getProperties(fromBean));
            return toBean;
        }
        catch (BeanBinderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BeanBinderException(ex);
        }
    }

    public static Properties getProperties(Object bean) throws Exception {
        return BeanBinder.getProperties(bean, false, new Properties());
    }

    public static Map<String, Object> getMap(Object bean) throws BeanBinderException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Class<?> beanClass = bean.getClass();
        Method[] methods = beanClass.getMethods();
        try {
            for (Method method : methods) {
                String metName = method.getName();
                if (!metName.startsWith("get") && !metName.startsWith("is") || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(Unbound.class)) continue;
                Object ret = method.invoke(bean, new Object[0]);
                map.put(BeanBinder.propertyName(metName), ret);
            }
            return map;
        }
        catch (Exception ex) {
            throw new BeanBinderException(ex);
        }
    }

    public static Properties getProperties(Object bean, Properties existing) throws Exception {
        return BeanBinder.getProperties(bean, false, existing);
    }

    public static Properties getProperties(Object bean, boolean nullProperties) throws Exception {
        return BeanBinder.getProperties(bean, nullProperties, new Properties());
    }

    private static Properties getProperties(Object bean, boolean nullProperties, Properties existing) throws Exception {
        Class<?> beanClass = bean.getClass();
        Method[] methods = beanClass.getMethods();
        Properties props = existing;
        for (Method method : methods) {
            Bean ba;
            String metName = method.getName();
            if (!metName.startsWith("get") && !metName.startsWith("is") || method.getParameterTypes().length != 0 || method.isAnnotationPresent(Unbound.class)) continue;
            Object ret = method.invoke(bean, new Object[0]);
            if (ret == null && nullProperties) {
                ret = "";
            }
            if ((ba = method.getAnnotation(Bean.class)) != null) {
                Properties prefixed = BeanBinder.getProperties(ret, nullProperties, new Properties());
                Properties defaults = BeanBinder.getProperties(ret.getClass().getConstructor(new Class[0]).newInstance(new Object[0]), nullProperties, new Properties());
                for (Map.Entry entry : prefixed.entrySet()) {
                    if (entry.getValue().equals(defaults.get(entry.getKey()))) continue;
                    props.put(BeanBinder.propertyName(metName) + "." + String.valueOf(entry.getKey()), entry.getValue());
                }
                continue;
            }
            if (ret != null && ret.getClass().getMethod("toString", new Class[0]).getDeclaringClass().equals(Object.class)) continue;
            if (ret instanceof List) {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (Object e : (List)ret) {
                    if (!first) {
                        buf.append(',');
                    }
                    buf.append(e.toString());
                    first = false;
                }
                ret = buf;
            } else if (ret instanceof Color) {
                Color color = (Color)ret;
                ret = Colors.toARGBHexColor(color);
            } else if (ret instanceof Enum) {
                ret = ((Enum)ret).name();
            } else if (ret instanceof Parameters) {
                ret = StringUtil.parametersToString((Parameters)ret);
            } else if (ret instanceof Map) {
                ret = StringUtil.mapToString((Map)ret);
            } else if (ret instanceof Set) {
                ret = StringUtil.setToString((Set)ret);
            }
            if (ret == null) continue;
            props.setProperty(BeanBinder.propertyName(metName), ret.toString());
        }
        return props;
    }

    public void addBinderListener(BinderListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BinderListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeBinderListener(BinderListener listener) {
        if (this.listeners == null) {
            ArrayList<BinderListener> clone = new ArrayList<BinderListener>(this.listeners);
            Iterator it = clone.iterator();
            while (it.hasNext()) {
                if (it.next() != listener) continue;
                it.remove();
                this.listeners = clone;
                return;
            }
        }
    }

    public void addUI(Container ... newUIs) {
        if (this.uis == null) {
            this.uis = new ArrayList<Container>();
        }
        for (Container ui : newUIs) {
            if (this.uis.contains(ui)) continue;
            this.uis.add(ui);
        }
    }

    public void addUI(Container ui) {
        if (this.uis == null) {
            this.uis = new ArrayList<Container>();
            if (!this.uis.contains(ui)) {
                this.uis.add(ui);
            }
        }
    }

    public void removeUI(Object ui) {
        if (this.uis == null) {
            ArrayList<Container> clone = new ArrayList<Container>(this.uis);
            Iterator it = clone.iterator();
            while (it.hasNext()) {
                if (it.next() != ui) continue;
                it.remove();
                this.uis = clone;
                return;
            }
        }
    }

    protected void fireWriteModel() {
        if (this.listeners != null) {
            for (BinderListener listener : this.listeners) {
                listener.writeModel();
            }
        }
    }

    protected void fireModelRead() {
        if (this.listeners != null) {
            for (BinderListener listener : this.listeners) {
                listener.modelRead();
            }
        }
    }

    public static void debug(Object bean, Object jComponentHolder) throws Exception {
        Field[] fields;
        Class<?> beanClass = bean.getClass();
        Method[] methods = beanClass.getMethods();
        System.out.println("Properties of bean:");
        for (Method method : methods) {
            String name = method.getName();
            if (!name.startsWith("get") && !name.startsWith("is")) continue;
            String property = name.startsWith("get") ? name.substring(3) : name.substring(2);
            System.out.println(property);
        }
        System.out.println("GUI componnents:");
        Class<?> guiClass = jComponentHolder.getClass();
        for (Field field : fields = BeanBinder.getFields(guiClass)) {
            Object comp;
            String name = field.getName();
            field.setAccessible(true);
            int mods = field.getModifiers();
            if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || !((comp = field.get(jComponentHolder)) instanceof JComponent)) continue;
            System.out.println(name + " " + comp.getClass().getName());
        }
    }

    public static void getProperties(Object bean, List<Container> holders) throws Exception {
        for (Container holder : holders) {
            BeanBinder.getProperties(bean, holder);
        }
    }

    public void readModel(Object bean) throws Exception {
        BeanBinder.getProperties(bean, this.uis);
        this.fireModelRead();
    }

    public void writeModel(Object bean) {
        this.fireWriteModel();
        BeanBinder.setProperties(bean, this.uis);
    }

    public void walkComponents(BiConsumer<String, JComponent> visitor) {
        for (Container ui : this.uis) {
            Field[] fields;
            Class<?> guiClass = ui.getClass();
            for (Field field : fields = BeanBinder.getFields(guiClass)) {
                String name = field.getName();
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) continue;
                try {
                    Object comp = field.get(ui);
                    if (!(comp instanceof JComponent)) continue;
                    visitor.accept(name, (JComponent)comp);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void getProperty(Object bean, Method method, Object comp) throws IllegalAccessException, InvocationTargetException {
        if (comp instanceof JComponent || comp instanceof ButtonGroup) {
            Object ret = method.invoke(bean, new Object[0]);
            if (ret == null) {
                ret = "";
            }
            if (comp instanceof JTextComponent) {
                if (ret instanceof Set) {
                    ret = StringUtil.setToString((Set)ret);
                }
                ((JTextComponent)comp).setText(ret.toString());
            } else if (comp instanceof JComboBox) {
                JComboBox jc = (JComboBox)comp;
                boolean setOk = false;
                for (int k = 0; k < jc.getItemCount(); ++k) {
                    Object item = jc.getItemAt(k);
                    if (!item.equals(ret)) continue;
                    if (jc.getSelectedIndex() != k) {
                        jc.setSelectedIndex(k);
                    }
                    setOk = true;
                    break;
                }
                if (!setOk) {
                    jc.setSelectedItem(ret);
                }
            } else if (comp instanceof JSlider) {
                JSlider js = (JSlider)comp;
                js.setValue((Integer)ret);
            } else if (comp instanceof JSpinner) {
                ((JSpinner)comp).setValue(ret);
            } else if (comp instanceof JCheckBox) {
                ((JCheckBox)comp).setSelected("true".equals(ret.toString()));
            } else if (comp instanceof JColorSelector) {
                JColorSelector cs = (JColorSelector)comp;
                if (ret instanceof Color) {
                    cs.setColor((Color)ret);
                } else {
                    cs.setColor(ret.toString());
                }
            } else if (comp instanceof ButtonGroup) {
                ButtonGroup bg = (ButtonGroup)comp;
                Enumeration<AbstractButton> buttons = bg.getElements();
                while (buttons.hasMoreElements()) {
                    AbstractButton button = buttons.nextElement();
                    String ac = button.getActionCommand();
                    if (ac == null || !ac.equals(ret.toString())) continue;
                    bg.setSelected(button.getModel(), true);
                    break;
                }
            } else if (comp instanceof PersistentList) {
                ((PersistentList)comp).setContent((List)ret);
            } else if (comp instanceof PersistentChoice) {
                ((PersistentChoice)comp).setChoice((String)ret);
            }
        }
        if (comp instanceof Bindeable) {
            ((Bindeable)comp).loadStateFromBean(bean);
        }
    }

    public static void getProperties(Object bean, Container jComponentHolder) {
        try {
            Field[] fields;
            synchingUI.set(Boolean.TRUE);
            Class<?> beanClass = bean.getClass();
            Method[] methods = beanClass.getMethods();
            Class<?> guiClass = jComponentHolder.getClass();
            for (Field field : fields = BeanBinder.getFields(guiClass)) {
                String name = field.getName();
                String getName = "get" + name;
                String isName = "is" + name;
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) continue;
                Object comp = field.get(jComponentHolder);
                for (Method m : methods) {
                    String metName = m.getName();
                    if (!metName.equalsIgnoreCase(getName) && !metName.equalsIgnoreCase(isName)) continue;
                    BeanBinder.getProperty(bean, m, comp);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new BeanBinderException(ex);
        }
        finally {
            synchingUI.remove();
        }
    }

    public static boolean isSynchingUI() {
        return Boolean.TRUE.equals(synchingUI.get());
    }

    public static void setProperties(Object bean, List<Container> uis) {
        for (Container ui : uis) {
            BeanBinder.setProperties(bean, ui);
        }
    }

    public static void setProperties(Object bean, Container jComponentHolder) throws BeanBinderException {
        try {
            HashMap<String, Object> components = new HashMap<String, Object>();
            Class<?> beanClass = bean.getClass();
            Method[] methods = BeanBinder.orderByCallOrder(beanClass.getMethods());
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            for (Field field : fields) {
                String name = field.getName();
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || field.isAnnotationPresent(IgnoreRead.class)) continue;
                Object comp = field.get(jComponentHolder);
                if (comp instanceof JComponent || comp instanceof ButtonGroup) {
                    components.put(name, comp);
                }
                if (!(comp instanceof Bindeable)) continue;
                ((Bindeable)comp).loadStateFromBean(bean);
            }
            for (AccessibleObject accessibleObject : methods) {
                Class<?>[] types;
                String name;
                Object comp;
                String metName = ((Method)accessibleObject).getName();
                if (!metName.startsWith("set") || accessibleObject.isAnnotationPresent(Unbound.class)) continue;
                char[] chars = metName.substring(3).toCharArray();
                if (chars.length > 0) {
                    chars[0] = Character.toLowerCase(chars[0]);
                }
                if ((comp = components.get(name = new String(chars))) == null || (types = ((Method)accessibleObject).getParameterTypes()).length != 1) continue;
                Class<?> type = types[0];
                Object val = null;
                try {
                    Object sel;
                    if (type.equals(String.class)) {
                        if (comp instanceof JTextComponent) {
                            val = ((JTextComponent)comp).getText();
                        } else if (comp instanceof JComboBox) {
                            sel = ((JComboBox)comp).getSelectedItem();
                            val = sel != null && sel instanceof Item ? ((Item)sel).value.toString() : (sel != null ? sel.toString() : null);
                        } else if (comp instanceof ButtonGroup) {
                            val = ((ButtonGroup)comp).getSelection().getActionCommand();
                        }
                    } else if (type.equals(Boolean.TYPE) && comp instanceof JCheckBox) {
                        val = ((JCheckBox)comp).isSelected();
                    } else if (type.equals(Color.class) && comp instanceof JColorSelector) {
                        val = ((JColorSelector)comp).getColor();
                    } else if (type.equals(Boolean.TYPE) && comp instanceof ButtonGroup) {
                        val = "true".equals(((ButtonGroup)comp).getSelection().getActionCommand());
                    } else if (type.equals(Integer.TYPE) && comp instanceof JTextField) {
                        val = Integer.valueOf(((JTextField)comp).getText());
                    } else if (type.equals(Float.TYPE) && comp instanceof JTextField) {
                        val = Float.valueOf(((JTextField)comp).getText());
                    } else if (type.equals(Double.TYPE) && comp instanceof JTextField) {
                        val = Double.valueOf(((JTextField)comp).getText());
                    } else if (type.equals(Integer.TYPE) && comp instanceof JSlider) {
                        val = ((JSlider)comp).getValue();
                    } else if (comp instanceof JSpinner) {
                        val = ((JSpinner)comp).getValue();
                    } else if (type.equals(Integer.TYPE) && comp instanceof JComboBox) {
                        sel = ((JComboBox)comp).getSelectedItem();
                        val = sel != null && sel instanceof Item ? Integer.valueOf(((Item)sel).value.toString()) : (sel != null ? Integer.valueOf(sel.toString()) : null);
                    } else if (type.isEnum() && comp instanceof JComboBox) {
                        val = ((JComboBox)comp).getSelectedItem();
                    } else if (comp instanceof PersistentList) {
                        val = ((PersistentList)comp).getContent();
                    } else if (comp instanceof PersistentChoice) {
                        val = ((PersistentChoice)comp).getChoice();
                    } else if (Set.class.isAssignableFrom(types[0]) && comp instanceof JTextComponent) {
                        val = StringUtil.stringToSet(((JTextComponent)comp).getText());
                    }
                    if (val == null) continue;
                    ((Method)accessibleObject).invoke(bean, val);
                }
                catch (InvocationTargetException ex) {
                    try {
                        BeanBinder.getProperty(bean, BeanBinder.getGetter(bean, name), comp);
                    }
                    catch (SecurityException ex1) {
                        Logger.getLogger(BeanBinder.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                    catch (NoSuchMethodException ex1) {
                        Logger.getLogger(BeanBinder.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                    catch (InvocationTargetException ex1) {
                        Logger.getLogger(BeanBinder.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Method getGetter(Object bean, String name) throws SecurityException, NoSuchMethodException {
        Class<?> beanClass = bean.getClass();
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        try {
            return beanClass.getMethod("get" + (String)name, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return beanClass.getMethod("is" + (String)name, new Class[0]);
        }
    }

    static final Field[] getFields(Class guiClass) {
        Class parent = guiClass.getSuperclass();
        if (parent == null || Object.class.equals(parent) || !JComponentHolder.class.isAssignableFrom(guiClass)) {
            return guiClass.getDeclaredFields();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        while (guiClass != null && JComponentHolder.class.isAssignableFrom(guiClass)) {
            Field[] f;
            for (Field f1 : f = guiClass.getDeclaredFields()) {
                if (fields.containsKey(f1.getName())) continue;
                fields.put(f1.getName(), f1);
            }
            guiClass = guiClass.getSuperclass();
        }
        return fields.values().toArray(new Field[0]);
    }

    public static interface Bindeable {
        public void saveStateToBean(Object var1);

        public void loadStateFromBean(Object var1);
    }
}

