/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.PropertyBinder;

public class Attributizer {
    JComponentHolder target;
    boolean commas = true;
    boolean spaces = true;
    boolean quotes = false;

    public Attributizer() {
    }

    public Attributizer(JComponentHolder target) {
        this.target = target;
    }

    public Attributizer(boolean commas, boolean spaces, boolean quotes) {
        this.commas = commas;
        this.spaces = spaces;
        this.quotes = quotes;
    }

    public void setTarget(JComponentHolder target) {
        this.target = target;
    }

    public String getAttributes() {
        if (this.target == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Properties props = PropertyBinder.getProperties(this.target);
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            if (!first) {
                if (this.commas) {
                    buf.append(',');
                }
                if (this.spaces) {
                    buf.append(' ');
                }
            }
            first = false;
            buf.append(e.getKey()).append("=");
            if (this.quotes) {
                buf.append('\"');
            }
            buf.append(e.getValue());
            if (!this.quotes) continue;
            buf.append('\"');
        }
        return buf.toString();
    }
}

