/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import se.datadosen.util.BeanBinder;

public class AttributeSerializer {
    public String toAttributeString(Object bean) {
        try {
            Properties def = BeanBinder.getProperties(bean.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
            def.remove("class");
            Properties props = BeanBinder.getProperties(bean);
            props.put("class", bean.getClass().getName());
            TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(props);
            StringBuilder buf = new StringBuilder();
            for (Map.Entry e : sorted.entrySet()) {
                if (((String)e.getValue()).equals(def.getProperty((String)e.getKey()))) continue;
                buf.append((String)e.getKey());
                buf.append("=\"");
                buf.append(AttributeSerializer.escapeQuotes((String)e.getValue()));
                buf.append("\" ");
            }
            return buf.toString().trim();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object toBean(Properties props, Object existingBean, Object templateBean) {
        try {
            if (props != null) {
                BeanBinder.setProperties(templateBean, props);
            }
            Properties allProps = BeanBinder.getProperties(templateBean);
            BeanBinder.setProperties(existingBean, allProps);
            return existingBean;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object toBean(Properties props, Object existingBean) {
        try {
            Object templateBean = existingBean.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            return this.toBean(props, existingBean, templateBean);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String escapeQuotes(String s) {
        s = s.replace("\\", "\\\\");
        return s.replace("\"", "\\\"");
    }
}

