/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class AliasAction
extends AbstractAction
implements PropertyChangeListener {
    protected Action target;
    protected Set<String> blockedKeys = new HashSet<String>();

    public AliasAction(Action target) {
        this.setAction(target);
    }

    public AliasAction(Action target, String name) {
        this(target);
        this.putValue("Name", name);
    }

    public AliasAction(Action target, Icon icon) {
        this(target);
        this.putValue("SmallIcon", icon);
    }

    public AliasAction(Action target, String name, Icon icon) {
        this(target);
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
    }

    public void setAction(Action target) {
        if (this.target != null) {
            this.target.removePropertyChangeListener(this);
        }
        this.target = target;
        if (target != null) {
            this.copyValue("AcceleratorKey");
            this.copyValue("ActionCommandKey");
            this.copyValue("SwingDisplayedMnemonicIndexKey");
            this.copyValue("SwingLargeIconKey");
            this.copyValue("LongDescription");
            this.copyValue("MnemonicKey");
            this.copyValue("Name");
            this.copyValue("SwingSelectedKey");
            this.copyValue("ShortDescription");
            this.copyValue("SmallIcon");
            this.setEnabled(target.isEnabled());
            target.addPropertyChangeListener(this);
        } else {
            this.setEnabled(false);
        }
    }

    public Action getAction() {
        return this.target;
    }

    private void copyValue(String key) {
        if (!this.blockedKeys.contains(key)) {
            super.putValue(key, this.target.getValue(key));
        }
    }

    @Override
    public void putValue(String key, Object newValue) {
        this.blockedKeys.add(key);
        super.putValue(key, newValue);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.target.actionPerformed(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (!this.blockedKeys.contains(key)) {
            super.putValue(key, evt.getNewValue());
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.target.isEnabled();
    }
}

