/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.datadosen.tags.Section;
import se.datadosen.util.CharBuffer;
import se.datadosen.util.IO;

public class Template {
    private List data = new LinkedList();
    final char keyPrefix;
    final int sizeHint;
    CharBuffer buffer;
    private File file;
    private Section section;

    public Template(File file) throws IOException {
        this(new Section(IO.readTextFile(file), file));
    }

    public Template(Section section) {
        this(section.toString());
        this.section = section;
        this.file = section.getSourceFile();
    }

    public File getFile() {
        return this.file;
    }

    public Template(String ts) {
        this(ts, '$');
    }

    public Template(String ts, char keyPrefix) {
        this.keyPrefix = keyPrefix;
        this.sizeHint = ts.length();
        int index = 0;
        int lastIndex = 0;
        while ((index = ts.indexOf(keyPrefix, index)) >= 0) {
            this.data.add(ts.substring(lastIndex, index));
            int keyLength = this.getKeyLength(ts, ++index);
            this.data.add(new Key(ts.substring(index, index + keyLength)));
            lastIndex = index += keyLength;
        }
        this.data.add(ts.substring(lastIndex));
    }

    private int getKeyLength(String s, int index) {
        char c;
        int i;
        for (i = index; i < s.length() && (Character.isJavaIdentifierPart(c = s.charAt(i)) || c == '.' && i + 1 < s.length() && Character.isJavaIdentifierPart(s.charAt(i + 1))); ++i) {
        }
        return i - index;
    }

    private static boolean isPrimitive(Class c) {
        if (c.isPrimitive()) {
            return true;
        }
        return c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class || c == Boolean.class || c == Character.class;
    }

    public static boolean isPrintable(Object o) {
        return o instanceof String || Template.isPrimitive(o.getClass()) || o instanceof File || o instanceof Date;
    }

    public Section toSection(Map<String, Object> mapping) {
        String result = this.toString(mapping);
        this.section = this.section.replaceSection(result);
        return this.section;
    }

    public String toString(Map<String, Object> mapping) {
        if (this.data.size() == 1 && this.data.get(0) instanceof String) {
            return (String)this.data.get(0);
        }
        StringBuilder buf = new StringBuilder(this.sizeHint);
        for (Object o : this.data) {
            if (o instanceof String) {
                buf.append((String)o);
                continue;
            }
            Key key = (Key)o;
            Object value = mapping.get(key.name);
            if (value != null && Template.isPrintable(value)) {
                buf.append(mapping.get(key.name));
                continue;
            }
            buf.append(this.keyPrefix);
            buf.append(key.name);
        }
        return buf.toString();
    }

    static class Key {
        String name;

        public Key(String name) {
            this.name = name;
        }
    }
}

