/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Section;

public class Elements {
    public static String stripComments(String doc) {
        int cEnd;
        int cStart = doc.indexOf("<!--");
        if (cStart == -1) {
            return doc;
        }
        StringBuilder buf = new StringBuilder();
        do {
            buf.append(doc.substring(0, cStart));
            doc = doc.substring(cStart);
            cEnd = doc.indexOf("-->");
            if (cEnd != -1) continue;
            return buf.toString();
        } while ((cStart = (doc = doc.substring(cEnd + 3)).indexOf("<!--")) != -1);
        buf.append(doc);
        return buf.toString();
    }

    public static Element getNextElement(String[] names, Section sec, boolean startsWith) throws ElementException {
        return Elements.getNextElement(names, sec, 0, startsWith);
    }

    static final int indexOfIntroducer(Section sec, int start) {
        int boff = sec.indexOf(60, start);
        int doff = sec.indexOf(36, start);
        if (boff == -1 && doff == -1) {
            return -1;
        }
        if (boff == -1) {
            boff = Integer.MAX_VALUE;
        }
        if (doff == -1) {
            doff = Integer.MAX_VALUE;
        }
        return boff < doff ? boff : doff;
    }

    public static Element getNextElement(String[] names, Section sec, int start, boolean startsWith) throws ElementException {
        int offset = start;
        while ((offset = Elements.indexOfIntroducer(sec, offset)) != -1) {
            char c;
            int i;
            if (sec.charAt(offset) == '$') {
                if (offset + 1 < sec.length() && sec.charAt(offset + 1) == '{') {
                    return Elements.getExpressionLanguage(sec);
                }
                ++offset;
                continue;
            }
            boolean endTag = false;
            if (sec.charAt(offset + 1) == '/') {
                endTag = true;
                ++offset;
            }
            for (i = 0; i < names.length && (!sec.startsWith(names[i], offset + 1) || !startsWith && (c = sec.charAt(offset + 1 + names[i].length())) != '=' && Character.isJavaIdentifierPart(c)); ++i) {
            }
            if (i == names.length) {
                ++offset;
                continue;
            }
            if (names[i].equals("%")) {
                return Elements.getScriptlet(sec);
            }
            Element e = new Element();
            e.preElement = sec.subsection(0, offset);
            if (names[i].equals("%--")) {
                int endOffset = sec.indexOf("--%>", offset + 1);
                if (endOffset != -1) {
                    e.name = names[i];
                    int contentIndex = offset + "<%--".length();
                    e.content = sec.subsection(contentIndex, endOffset);
                    e.postIndex = endOffset + "--%>".length();
                    e.postElement = sec.subsection(e.postIndex);
                    return e;
                }
                throw new ElementException("JSP style comment has no ending tag", sec, offset);
            }
            AttributeTokenizer at = new AttributeTokenizer(sec.toString(), offset + 1);
            String name = e.name = at.nextName();
            if (endTag) {
                throw new ElementException("Element /" + e.name + " has no matching beginning tag", sec, offset);
            }
            while (at.hasMoreTokens()) {
                e.attributes.put(at.nextName(), at.nextValue());
            }
            offset = at.getPosition();
            char c2 = sec.charAt(offset);
            if (c2 == '/') {
                e.content = sec.subsection(offset, offset);
                e.postElement = sec.subsection(offset + 2);
                e.postIndex = offset + 2;
                return e;
            }
            if (c2 != '>') {
                throw new ElementException("Begin tag for element " + e.name + " not closed", sec, offset);
            }
            int contentStart = offset + 1;
            while ((offset = sec.indexOf(60, offset)) != -1) {
                if (sec.startsWith(name, offset + 1)) {
                    Element subElem = Elements.getNextElement(new String[]{name}, sec, offset, startsWith);
                    offset = subElem.getPostIndex() - 1;
                } else if (sec.startsWith("/" + name, offset + 1)) {
                    e.content = sec.subsection(contentStart, offset);
                    if ((offset = sec.indexOf(62, offset)) == -1) {
                        throw new ElementException("Element " + e.name + " has malformad ending tag", sec, e.preElement.length());
                    }
                    e.postElement = sec.subsection(offset + 1);
                    e.postIndex = offset + 1;
                    return e;
                }
                ++offset;
            }
            throw new ElementException("Element " + e.name + " has no matching ending tag", sec, e.preElement.length());
        }
        return null;
    }

    public static Element getElementByName(String name, String doc, boolean startsWith) throws ElementException {
        return Elements.getElementByName(name, new Section(doc), startsWith);
    }

    public static Element getElementByName(String name, Section sec, boolean startsWith) throws ElementException {
        return Elements.getNextElement(new String[]{name}, sec, startsWith);
    }

    public static String contentOfElement(String name, String doc) throws ElementException {
        Element el = Elements.getElementByName(name, doc, false);
        return el != null ? el.getContent().toString() : null;
    }

    public static Element getScriptlet(Section sec) throws ElementException {
        int offset = 0;
        while ((offset = sec.indexOf(60, offset)) != -1) {
            if (sec.charAt(offset + 1) != '%') {
                ++offset;
                continue;
            }
            Element e = new Element();
            e.name = "%";
            e.preElement = sec.subsection(0, offset);
            int contentStart = offset + 2;
            switch (sec.charAt(contentStart)) {
                case '=': {
                    e.evalScriptlet = true;
                    ++contentStart;
                    break;
                }
                case '!': {
                    e.definitionScriptlet = true;
                    ++contentStart;
                }
            }
            offset = contentStart;
            while ((offset = sec.indexOf(37, offset)) != -1) {
                if (sec.charAt(offset + 1) != '>') {
                    ++offset;
                    continue;
                }
                e.content = sec.subsection(contentStart, offset);
                e.postElement = sec.subsection(offset + 2);
                return e;
            }
            throw new ElementException("Scriptlet has no ending", sec);
        }
        return null;
    }

    public static Element getExpressionLanguage(Section sec) throws ElementException {
        int offset = 0;
        while ((offset = sec.indexOf(36, offset)) != -1) {
            int contentStart;
            if (sec.charAt(offset + 1) != '{') {
                ++offset;
                continue;
            }
            Element e = new Element();
            e.name = "$";
            e.preElement = sec.subsection(0, offset);
            offset = contentStart = offset + 2;
            if ((offset = sec.indexOf(125, offset)) == -1) {
                throw new ElementException("Expression has no ending brace", sec, offset);
            }
            e.content = sec.subsection(contentStart, offset);
            e.postElement = sec.subsection(offset + 1);
            return e;
        }
        return null;
    }
}

