/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import java.io.File;
import se.datadosen.tags.Section;
import se.datadosen.util.ContextualException;

public class ElementException
extends Exception
implements ContextualException {
    private File file;
    private int lineNumber = -1;
    private int columnNumber = -1;

    public ElementException(String msg) {
        super(msg);
    }

    public ElementException(String message, Throwable cause) {
        super(message, cause);
    }

    public ElementException(Throwable cause) {
        super(cause);
    }

    public ElementException(String message, File file, int lineNumber) {
        super(message);
        this.file = file;
        this.lineNumber = lineNumber;
        this.columnNumber = -1;
    }

    public ElementException(String message, File file, int lineNumber, int columnNumber) {
        super(message);
        this.file = file;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ElementException(String message, Section sec, int index) {
        this(message, sec.getSourceFile(), sec.getSourceLineNumber(index));
    }

    public ElementException(String message, Section sec) {
        this(message, sec, 0);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getMessage() {
        Object ret = super.getMessage();
        if (this.file != null) {
            ret = (String)ret + " (" + this.file.getName() + ":" + this.lineNumber + ")";
        }
        return ret;
    }
}

