/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.videoplayer;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.MediaPlayerProcessor;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.videoplayer.MediaControl;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;

public class VideoPlayer {
    Stage stage;
    AlbumObject ao;
    private Throwable lastError;
    private MediaPlayer mediaPlayer;
    MediaPlayerProcessor mediaPlayerProcessor = new MediaPlayerProcessor();
    private CountDownLatch latch = new CountDownLatch(1);

    public VideoPlayer(AlbumObject ao) throws IOException {
        this.ao = ao;
        if (Platform.isFxApplicationThread()) {
            this.init();
        } else {
            this.latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                try {
                    this.init();
                }
                catch (IOException t) {
                    if (this.mediaPlayer != null) {
                        this.mediaPlayer.dispose();
                    }
                    this.lastError = t;
                    this.latch.countDown();
                }
            });
            try {
                this.latch.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.lastError != null) {
                if (this.lastError instanceof MediaException) {
                    throw new IOException(this.lastError);
                }
                if (this.lastError instanceof IOException) {
                    throw (IOException)this.lastError;
                }
                throw new RuntimeException(this.lastError);
            }
        }
    }

    private void init() throws IOException {
        Platform.setImplicitExit((boolean)false);
        this.mediaPlayerProcessor.fxSetMedia(this.ao.getFile());
        this.stage = new Stage(StageStyle.DECORATED);
        this.stage.setTitle(this.ao.getName());
        Media media = new Media(this.ao.getFile().toURI().toString());
        this.mediaPlayer = new MediaPlayer(media);
        MediaControl mediaControl = new MediaControl(this, this.mediaPlayer);
        Scene scene = new Scene((Parent)mediaControl, 800.0, 500.0);
        this.stage.setScene(scene);
        this.mediaPlayer.statusProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == MediaPlayer.Status.READY) {
                this.latch.countDown();
                Rectangle2D r = Screen.getPrimary().getVisualBounds();
                Dimension dim = GraphicsUtilities.fitWithinBounds(media.getWidth(), media.getHeight(), new Dimension((int)(r.getWidth() * 0.9), (int)(r.getHeight() * 0.9)));
                this.stage.setWidth((double)dim.width);
                this.stage.setHeight((double)dim.height);
                this.stage.centerOnScreen();
                this.stage.setOnHidden(eh -> {
                    this.mediaPlayer.dispose();
                    this.mediaPlayerProcessor.dispose();
                });
                this.stage.show();
            } else if (newValue == MediaPlayer.Status.HALTED) {
                this.lastError = this.mediaPlayer.getError();
                this.latch.countDown();
                JAlbum.logger.fine(this.mediaPlayer.getError().toString());
            }
        });
        mediaControl.getMediaView().fitWidthProperty().bind((ObservableValue)this.stage.widthProperty());
        mediaControl.getMediaView().fitHeightProperty().bind((ObservableValue)this.stage.heightProperty());
        this.mediaPlayer.setOnError(() -> {
            this.lastError = this.mediaPlayer.getError();
            this.mediaPlayer.stop();
            this.latch.countDown();
            JAlbum.logger.fine(this.mediaPlayer.getError().toString());
        });
    }

    void createSnapshot(TimeCode time) {
        SwingUtilities.invokeLater(() -> {
            try {
                BufferedImage snapshot = this.mediaPlayerProcessor.createSnapshot(this.mediaPlayer);
                File repFile = this.ao.getRepresentingImageFile();
                FileFilters.saveJPEG(snapshot, repFile, JAlbumContext.getInstance().getEngine());
                this.ao.updateRepresentingIcon();
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(null, ex);
            }
        });
        ColorAdjust colorAdjust = new ColorAdjust();
        this.stage.getScene().getRoot().setEffect((Effect)colorAdjust);
        Timeline flashTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)colorAdjust.brightnessProperty(), (Object)1, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)colorAdjust.brightnessProperty(), (Object)0, Interpolator.LINEAR)})});
        flashTimeline.setOnFinished(e -> this.stage.getScene().getRoot().setEffect(null));
        flashTimeline.play();
        AudioClip shutterSound = new AudioClip(this.getClass().getResource("camera-shutter-click-03.wav").toExternalForm());
        shutterSound.play();
    }
}

