/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.VirtualFolder;

public interface Transformer<T extends Transformer>
extends Serializable {
    default public AlbumObject transform(AlbumObject tree) {
        return this.transform(tree, new VirtualFolder(tree.getFile(), null, tree.getFactory()));
    }

    public AlbumObject transform(AlbumObject var1, VirtualFolder var2);

    public T copy();

    default public void sortFolders(List<AlbumObject> children) {
        if (children.stream().filter(ao -> ao.isFolder()).findAny().isEmpty()) {
            return;
        }
        Collections.sort(children, (ao1, ao2) -> ao1.getName().compareToIgnoreCase(ao2.getName()));
        for (AlbumObject ao3 : children) {
            if (!ao3.isFolder()) continue;
            this.sortFolders(ao3.getChildren());
        }
    }
}

