/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.util.Date;
import java.util.Objects;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.jalbum.structure.Transformer;

public class RecentlyAddedTransformer
implements Transformer<RecentlyAddedTransformer> {
    private ThresholdType type = ThresholdType.SINCE_N_DAYS;
    private int days = 30;
    private long date;

    @Override
    public RecentlyAddedTransformer copy() {
        RecentlyAddedTransformer copy = new RecentlyAddedTransformer();
        copy.type = this.type;
        copy.days = this.days;
        copy.date = this.date;
        return copy;
    }

    public ThresholdType getType() {
        return this.type;
    }

    public void setType(ThresholdType type) {
        this.type = type;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public long getThresholdDate(AlbumObject root) {
        switch (this.type.ordinal()) {
            case 2: {
                return this.date;
            }
            case 0: {
                return new Date().getTime() - (long)this.days * 1000L * 3600L * 24L;
            }
            case 1: {
                return root != null ? root.getProperties().get("lastPublishedDate", 0L) : 0L;
            }
        }
        return 0L;
    }

    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) {
        long thresholdDate = this.getThresholdDate(tree.getRoot());
        Support.toStream(tree).filter(ao -> ao.getWhenAdded() >= thresholdDate).sorted(AlbumObject.Ordering.addedDate.getComparator(true)).forEach(ao -> newRoot.addFileOf((AlbumObject)ao));
        return newRoot;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode((Object)this.type);
        hash = 89 * hash + this.days;
        hash = 89 * hash + (int)(this.date ^ this.date >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecentlyAddedTransformer other = (RecentlyAddedTransformer)obj;
        if (this.days != other.days) {
            return false;
        }
        if (this.date != other.date) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum ThresholdType {
        SINCE_N_DAYS,
        SINCE_LAST_PUBLISHED,
        SINCE_DATE;


        public String toString() {
            return Msg.get("ThresholdType." + this.name());
        }
    }
}

