/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.util.ArrayList;
import java.util.List;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.PlaceService;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.io.VirtualDirectory;
import se.datadosen.jalbum.structure.PlaceFormat;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.jalbum.structure.Transformer;

public class PlaceTransformer
implements Transformer<PlaceTransformer> {
    private List<String> patternGroups = new ArrayList<String>();
    private transient PlaceService geolocService;

    public PlaceTransformer() {
        this.patternGroups.add("ccc");
        this.patternGroups.add("rrr");
        this.patternGroups.add("ppp");
    }

    public List<String> getPatternGroups() {
        return new ArrayList<String>(this.patternGroups);
    }

    public void setPatternGroups(List<String> patternGroups) {
        this.patternGroups = new ArrayList<String>(patternGroups);
    }

    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) {
        this.geolocService = PlaceService.getInstance();
        Support.toStream(tree).sorted((o1, o2) -> {
            long d2;
            long d1 = PlaceTransformer.getCameraDate(o1);
            if (d1 == (d2 = PlaceTransformer.getCameraDate(o2))) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        }).forEach(ao -> this.add((AlbumObject)ao, newRoot));
        if (newRoot instanceof ViewAlbumObject) {
            this.sortFolders(((ViewAlbumObject)newRoot).safeGetChildren());
        } else {
            this.sortFolders(newRoot.getChildren());
        }
        return newRoot;
    }

    private void add(AlbumObject ao, VirtualFolder parent) {
        PlaceService.Place place = this.geolocService.getPlace(ao);
        if (place != null) {
            for (String pattern : this.patternGroups) {
                if (pattern.length() <= 0) continue;
                PlaceFormat formatter = new PlaceFormat(pattern);
                String part = formatter.format(place);
                VirtualFolder folder = (VirtualFolder)parent.getChild(part);
                if (folder == null) {
                    folder = new VirtualFolder(new VirtualDirectory(parent.getFile(), part), parent, parent.getFactory());
                    parent.add(folder);
                }
                parent = folder;
            }
            parent.addFileOf(ao);
        }
    }

    private static long getCameraDate(AlbumObject ao) {
        long cameraDate = ao.getCameraDate();
        return cameraDate != 0L ? cameraDate : ao.getLastModified();
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.patternGroups != null ? this.patternGroups.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlaceTransformer other = (PlaceTransformer)obj;
        return this.patternGroups == other.patternGroups || this.patternGroups != null && this.patternGroups.equals(other.patternGroups);
    }

    @Override
    public PlaceTransformer copy() {
        PlaceTransformer copy = new PlaceTransformer();
        copy.patternGroups = new ArrayList<String>(this.patternGroups);
        return copy;
    }
}

