/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.structure.Transformer;

public class LimitTransformer
implements Transformer<LimitTransformer> {
    private int limit;
    private transient int counter = 0;
    private transient Set<String> sampleNames = new HashSet<String>();

    public LimitTransformer(int limit) {
        this.limit = limit;
    }

    private void processFolder(AlbumObject parent, VirtualFolder newParent) {
        for (AlbumObject ao : parent.getChildren()) {
            if (!ao.isFolder()) {
                if (!this.sampleNames.contains(ao.getName()) && ao.isIncluded() && ++this.counter > this.limit) {
                    throw new OperationAbortedException("Limit reached");
                }
                newParent.add(ao);
                continue;
            }
            VirtualFolder vf = new VirtualFolder(ao.getFile(), newParent, ao.getFactory());
            newParent.add(vf);
            try {
                this.processFolder(ao, vf);
            }
            catch (OperationAbortedException ex) {
                if (vf.getChildren().size() == 0) {
                    newParent.remove(vf);
                }
                throw ex;
            }
        }
    }

    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) {
        try {
            String line;
            InputStream is = this.getClass().getResourceAsStream("samples/" + tree.getName() + ".txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                this.sampleNames.add(line);
            }
        }
        catch (NullPointerException is) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            this.processFolder(tree, newRoot);
        }
        catch (OperationAbortedException operationAbortedException) {
            // empty catch block
        }
        return newRoot;
    }

    public boolean isLimited() {
        return this.counter > this.limit;
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public LimitTransformer copy() {
        LimitTransformer copy = new LimitTransformer(this.limit);
        return copy;
    }
}

