/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.io.VirtualDirectory;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.jalbum.structure.Transformer;
import se.datadosen.util.IO;

public class KeywordTransformer
implements Transformer<KeywordTransformer> {
    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) {
        Support.toStream(tree).sorted((o1, o2) -> {
            String kw1 = o1.getKeywords();
            String kw2 = o2.getKeywords();
            return kw1.compareTo(kw2);
        }).forEach(ao -> this.add((AlbumObject)ao, newRoot));
        if (newRoot instanceof ViewAlbumObject) {
            this.sortFolders(((ViewAlbumObject)newRoot).safeGetChildren());
        } else {
            this.sortFolders(newRoot.getChildren());
        }
        return newRoot;
    }

    private void add(AlbumObject ao, VirtualFolder parent) {
        for (String keyword : ao.getKeywordSet()) {
            keyword = keyword.replace('/', '-');
            VirtualFolder folder = (VirtualFolder)parent.getChild(IO.webSafe(keyword = keyword.replace('\\', '-')));
            if (folder == null) {
                folder = new VirtualFolder(new VirtualDirectory(parent.getFile(), keyword), parent, parent.getFactory());
                try {
                    if (folder.getOrdering() == AlbumObject.Ordering.custom) {
                        folder.setOrdering(AlbumObject.Ordering.name);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(KeywordTransformer.class.getName()).log(Level.SEVERE, null, ex);
                }
                parent.add(folder);
            }
            folder.addFileOf(ao);
        }
    }

    @Override
    public KeywordTransformer copy() {
        return new KeywordTransformer();
    }
}

