/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultTreeModel;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.JSettingsWindow;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.structure.AlphabeticalTransformer;
import se.datadosen.jalbum.structure.CalendarTransformer;
import se.datadosen.jalbum.structure.DummyNode;
import se.datadosen.jalbum.structure.FlattenTransformer;
import se.datadosen.jalbum.structure.JDateGroupsPanel;
import se.datadosen.jalbum.structure.Transformer;
import se.datadosen.util.Debug;
import se.datadosen.util.Multilingual;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JStructurePanel
extends ControlPanel {
    private final JSettingsWindow parent;
    @Icon(value="16x16/lightbulb.svg")
    @Text(value="structure.info")
    JLabel structureInfoLabel = new WrappableJLabel();
    @Text(value="structure.mirrorExisting")
    @ToolTipText(value="structure.mirrorExistingToolTip")
    private JRadioButton mirrorExisting = new JRadioButton("", true);
    @Text(value="structure.flat")
    @ToolTipText(value="structure.flatToolTip")
    private JRadioButton flat = new JRadioButton();
    @Text(value="structure.alphabetical")
    @ToolTipText(value="structure.alphabeticalToolTip")
    private JRadioButton alphabetical = new JRadioButton();
    @Text(value="structure.calendar")
    @ToolTipText(value="structure.calendarToolTip")
    private JRadioButton calendar = new JRadioButton();
    private JLabel description = new JLabel();
    private ButtonGroup structure = new ButtonGroup();
    @Text(value="ui.example")
    private JLabel exampleLabel;
    private boolean updatingUI;
    private AlbumObject rootFolder;
    private MultilingualTree tree;
    private JDateGroupsPanel groupsPanel;

    private void populateTreeWith(String[] nodeNames) {
        DummyNode root = new DummyNode();
        for (String s : nodeNames) {
            DummyNode node = new DummyNode(s);
            root.add(node);
        }
        this.tree.setModel(new DefaultTreeModel(root));
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public JStructurePanel(JSettingsWindow parent) {
        this.structure.add(this.mirrorExisting);
        this.structure.add(this.flat);
        this.structure.add(this.alphabetical);
        this.structure.add(this.calendar);
        this.exampleLabel = new JLabel();
        this.updatingUI = false;
        this.tree = new MultilingualTree();
        this.groupsPanel = new JDateGroupsPanel(this.tree);
        this.parent = parent;
        this.init();
    }

    private void updateExample() {
        if (this.calendar.isSelected()) {
            this.groupsPanel.updateSample();
            return;
        }
        if (this.flat.isSelected()) {
            DummyNode root = new DummyNode();
            this.tree.setModel(new DefaultTreeModel(root));
        } else if (this.alphabetical.isSelected()) {
            this.populateTreeWith(new String[]{"A", "B", "C"});
        } else {
            this.populateTreeWith(new String[]{"Nature", "Street", "Macro", "Sports"});
        }
        this.saveStateIfChanged();
    }

    private AbstractButton getSelectedButton(ButtonGroup bg) {
        Enumeration<AbstractButton> e = bg.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isSelected()) continue;
            return b;
        }
        return null;
    }

    private void init() {
        Msg.maintainTranslated(this);
        JPanel mainPanel = new JPanel();
        TitledBorder title = new TitledBorder(Msg.get("structure.title"));
        Border inner = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        mainPanel.setBorder(BorderFactory.createCompoundBorder(title, inner));
        this.groupsPanel.addPropertyChangeListener("patternGroups", evt -> {
            this.validate();
            this.saveStateIfChanged();
        });
        new StateMonitor(){

            @Override
            public void onChange() {
                AbstractButton sel = JStructurePanel.this.getSelectedButton(JStructurePanel.this.structure);
                if (sel != null) {
                    JStructurePanel.this.description.setText(sel.getToolTipText());
                }
                JStructurePanel.this.updateExample();
            }
        }.add(this.mirrorExisting).add(this.flat).add(this.alphabetical).add(this.calendar).done();
        mainPanel.setLayout(new BorderLayout());
        ControlPanel eastPanel = new ControlPanel();
        eastPanel.add(this.exampleLabel);
        eastPanel.add("br hfill vfill", new JScrollPane(this.tree));
        mainPanel.add((Component)eastPanel, "East");
        Box centerPanel = Box.createVerticalBox();
        Box buttons = Box.createHorizontalBox();
        buttons.setAlignmentX(0.0f);
        buttons.add(this.mirrorExisting);
        buttons.add(this.flat);
        buttons.add(this.alphabetical);
        buttons.add(this.calendar);
        centerPanel.add(buttons);
        centerPanel.add(Box.createVerticalStrut(8));
        centerPanel.add(this.description);
        centerPanel.add(Box.createVerticalStrut(20));
        centerPanel.add(this.groupsPanel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        mainPanel.add((Component)centerPanel, "Center");
        this.add("br", this.structureInfoLabel);
        this.add("p hfill vfill", mainPanel);
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.calendar, (JComponent)this.groupsPanel);
        this.parent.parent.addPropertyChangeListener("rootFolder", evt -> {
            this.updatingUI = true;
            this.rootFolder = (AlbumObject)evt.getNewValue();
            if (this.rootFolder != null) {
                Transformer transformer = (Transformer)this.rootFolder.getProperties().get("transformer");
                if (transformer == null) {
                    this.mirrorExisting.setSelected(true);
                } else if (transformer instanceof FlattenTransformer) {
                    this.flat.setSelected(true);
                } else if (transformer instanceof AlphabeticalTransformer) {
                    this.alphabetical.setSelected(true);
                } else if (transformer instanceof CalendarTransformer) {
                    this.calendar.setSelected(true);
                    CalendarTransformer calTrans = (CalendarTransformer)transformer;
                    this.groupsPanel.setPatternGroups(calTrans.getPatternGroups());
                }
            } else {
                this.mirrorExisting.setSelected(true);
            }
            this.updatingUI = false;
        });
    }

    public void saveStateIfChanged() {
        if (!this.updatingUI && this.rootFolder != null) {
            Transformer<FlattenTransformer> newTransformer;
            AlbumObjectProperties props = this.rootFolder.getProperties();
            Transformer oldTransformer = (Transformer)props.get("transformer");
            if (this.mirrorExisting.isSelected()) {
                if (oldTransformer == null) {
                    return;
                }
                props.remove("transformer");
            } else if (this.flat.isSelected()) {
                newTransformer = new FlattenTransformer();
                if (newTransformer.equals(oldTransformer)) {
                    return;
                }
                props.put("transformer", newTransformer);
            } else if (this.alphabetical.isSelected()) {
                newTransformer = new AlphabeticalTransformer();
                if (newTransformer.equals(oldTransformer)) {
                    return;
                }
                props.put("transformer", newTransformer);
            } else {
                CalendarTransformer calTrans = new CalendarTransformer();
                calTrans.setPatternGroups(this.groupsPanel.getPatternGroups());
                if (calTrans.equals(oldTransformer)) {
                    return;
                }
                props.put("transformer", calTrans);
            }
            try {
                props.store(true);
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        }
    }

    private class MultilingualTree
    extends JTree
    implements Multilingual {
        private MultilingualTree() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(130, 200);
        }

        @Override
        public void languageUpdated() {
            JStructurePanel.this.updateExample();
        }
    }
}

