/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.jalbum.undo.UndoHandler;
import se.datadosen.component.ControlPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.PlaceService;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.structure.JOrganizeDialog;
import se.datadosen.jalbum.structure.JPlaceGroupsPanel;
import se.datadosen.jalbum.structure.PlaceFormat;
import se.datadosen.util.Debug;
import se.datadosen.util.Multilingual;
import se.datadosen.util.annotations.Text;

public class JPlaceGroupingDialog
extends JOrganizeDialog {
    private static List<String> patternGroups;
    int skipped = 0;
    protected JCheckBox deleteEmptyFolders = new JCheckBox(Msg.get("ui.deleteEmptyFolders"), true);
    @Text(value="ui.example")
    private final JLabel exampleLabel = new JLabel();
    private MultilingualTree tree = new MultilingualTree();
    private JPlaceGroupsPanel groupsPanel = new JPlaceGroupsPanel(this.tree);
    private PlaceService geolocService = PlaceService.getInstance();
    private final Action okAction = new AbstractAction(Msg.get("edit.processNObjects", "-----")){
        {
            if (patternGroups != null) {
                JPlaceGroupingDialog.this.groupsPanel.setPatternGroups(patternGroups);
            }
            this.setEnabled(false);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.putValue("Name", Msg.get("edit.processNObjects", JPlaceGroupingDialog.this.counters.getFileCount()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("Group by place");
            this.setEnabled(false);
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    UndoHandler.getInstance().undoableEditHappened(this, JPlaceGroupingDialog.this.groupEdit);
                    JPlaceGroupingDialog.this.group(JPlaceGroupingDialog.this.selectedObjects, JPlaceGroupingDialog.this.destinationFolder);
                    return null;
                }

                @Override
                protected void done() {
                    block4: {
                        JPlaceGroupingDialog.this.groupEdit.end();
                        UndoHandler.getInstance().update();
                        JPlaceGroupingDialog.this.window.albumExplorer.redraw();
                        try {
                            JPlaceGroupingDialog.this.logSave(JPlaceGroupingDialog.this.destinationFolder);
                            JPlaceGroupingDialog.this.organizingDone();
                            this.get();
                            JPlaceGroupingDialog.this.setVisible(false);
                            if (JPlaceGroupingDialog.this.skipped > 0) {
                                JOptionPane.showMessageDialog(JPlaceGroupingDialog.this.window, Msg.get("ui.missingLocationMessage", JPlaceGroupingDialog.this.skipped), Msg.get("edit.groupByPlace"), 1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof OperationAbortedException) break block4;
                            Debug.showErrorDialog(JPlaceGroupingDialog.this, cause);
                        }
                    }
                    this.setEnabled(true);
                }
            };
            worker.execute();
        }
    };

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            patternGroups = this.groupsPanel.getPatternGroups();
        }
    }

    public void group(List<AlbumObject> objects, AlbumObject dest) throws IOException, PermissionException, InterruptedException {
        if (objects != null) {
            ArrayList<AlbumObject> list = new ArrayList<AlbumObject>();
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("engine.readingMetadataInfo"), null, 1, this.counters.getFileCount());
            this.toList(objects, list, ao -> ao.getMetadata());
            list.sort((o1, o2) -> {
                long d2;
                long d1 = JPlaceGroupingDialog.getCameraDate(o1);
                if (d1 == (d2 = JPlaceGroupingDialog.getCameraDate(o2))) {
                    return 0;
                }
                return d1 > d2 ? 1 : -1;
            });
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("ui.grouping"), null, 1, this.counters.getFileCount());
            for (AlbumObject ao2 : list) {
                this.processObject(ao2, dest);
            }
        }
    }

    private static long getCameraDate(AlbumObject ao) {
        long cameraDate = ao.getCameraDate();
        return cameraDate != 0L ? cameraDate : ao.getLastModified();
    }

    private void processObject(AlbumObject ao, AlbumObject parent) throws IOException, PermissionException {
        AlbumObject dest = parent;
        PlaceService.Place place = this.geolocService.getPlace(ao);
        if (place == null) {
            ++this.skipped;
            return;
        }
        for (String pattern : this.groupsPanel.getPatternGroups()) {
            if (pattern.length() <= 0) continue;
            PlaceFormat formatter = new PlaceFormat(pattern);
            String part = formatter.format(place);
            AlbumObject folder = parent.getChild(part);
            if (folder == null) {
                folder = parent == dest ? parent.createFolder(this.insertIndex++, part) : parent.createFolder(part);
            }
            parent = folder;
        }
        if (!ao.getFile().getParentFile().equals(parent.getFile())) {
            AlbumObject oldParent = ao.getParent();
            AlbumObject existing = parent.getChild(ao.getName());
            if (existing != null && JPlaceGroupingDialog.isDuplicate(existing, ao)) {
                System.out.println(Msg.get("edit.deletingDuplicateFile", ao));
                ao.delete();
            } else {
                this.move(ao, parent, parent.getUniqueName(ao.getName()));
            }
            if (this.deleteEmptyFolders.isSelected() && oldParent.getChildren().isEmpty()) {
                try {
                    this.treeDeleteEmpty(oldParent, dest);
                }
                catch (IOException | PermissionException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        }
        this.monitor.setProgress(++this.processed);
        this.monitor.setNote(ao.getName());
        if (this.monitor.isCanceled() || !this.isVisible()) {
            throw new OperationAbortedException();
        }
    }

    public JPlaceGroupingDialog(JAlbumFrame window, List<AlbumObject> selectedObjects, AlbumObject dest, int insertIndex) {
        super(window, Msg.get("edit.groupByPlace"), selectedObjects, dest, insertIndex);
        this.init();
    }

    @Override
    protected void init() {
        this.groupsPanel.addPropertyChangeListener("patternGroups", evt -> this.validate());
        Msg.maintainTranslated(this);
        Box topContent = Box.createHorizontalBox();
        topContent.add(this.groupsPanel);
        ControlPanel eastPanel = new ControlPanel();
        eastPanel.add(this.exampleLabel);
        eastPanel.add("br hfill vfill", new JScrollPane(this.tree));
        topContent.add(eastPanel);
        Box content = Box.createVerticalBox();
        this.groupsPanel.setAlignmentY(0.5f);
        content.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        content.add(topContent);
        content.add(this.deleteEmptyFolders);
        this.add(content);
        super.init();
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }

    private class MultilingualTree
    extends JTree
    implements Multilingual {
        private MultilingualTree() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(130, 200);
        }

        @Override
        public void languageUpdated() {
            JPlaceGroupingDialog.this.groupsPanel.updateSample();
        }
    }
}

