/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.jalbum.undo.UndoableGroupEdit;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CategoryCounters;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.structure.LimitedQueue;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.NamedThreadFactory;

public abstract class JOrganizeDialog
extends JSmartDialog {
    protected JAlbumFrame window;
    protected ProgressMonitor monitor;
    protected ExecutorService executorPool;
    protected int processed = 0;
    protected List<AlbumObject> selectedObjects;
    protected AlbumObject destinationFolder;
    protected int insertIndex;
    protected final CategoryCounters counters = new CategoryCounters();
    protected final UndoableGroupEdit groupEdit;
    private StringBuilder moveLog = new StringBuilder();
    protected Action cancelAction = new AbstractAction(Msg.get("cancel")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JOrganizeDialog.this.setVisible(false);
        }
    };
    protected Action okAction;

    protected void logFileMove(File from, File to, AlbumObject rel) {
        this.moveLog.append(IO.relativePath(from, rel.getFile())).append('\t').append(IO.relativePath(to, rel.getFile())).append('\n');
    }

    protected void logSave(AlbumObject dest) {
        try {
            File jalbumDir = new File(dest.getFile(), ".jalbum");
            jalbumDir.mkdir();
            File logFile = IO.ensureUnique(jalbumDir, "movedfiles.log");
            IO.writeTextFile(this.moveLog.toString(), logFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JOrganizeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void move(AlbumObject src, AlbumObject newParent, String newName) throws IOException {
        this.move(src, newParent, newName, -1);
    }

    protected void move(AlbumObject ao, AlbumObject dest, String newName, int position) throws IOException {
        File from = ao.getFile();
        ao.moveTo(dest, dest.getUniqueName(ao.getName()), position);
        File to = ao.getFile();
        this.logFileMove(from, to, this.destinationFolder);
    }

    protected void organizingDone() {
        TipOfTheDay.showInBackground(Msg.get("tip.undoIsPossible"), 10);
    }

    public JOrganizeDialog(JAlbumFrame window, String title, List<AlbumObject> selectedObjects, AlbumObject dest, int insertIndex) {
        super(window, title, true);
        this.window = window;
        this.selectedObjects = JOrganizeDialog.filterObjects(selectedObjects);
        this.destinationFolder = dest;
        this.insertIndex = insertIndex;
        this.groupEdit = new UndoableGroupEdit(title);
    }

    public static List<AlbumObject> filterObjects(List<AlbumObject> selectedObjects) {
        Iterator<AlbumObject> it = selectedObjects.iterator();
        while (it.hasNext()) {
            AlbumObject ao = it.next();
            if (!ao.isFolder() || !ao.isHidden()) continue;
            it.remove();
        }
        return selectedObjects;
    }

    protected void init() {
        this.okAction = this.getOkAction();
        this.registerActions(this.okAction, this.cancelAction);
        ContextHelp.getInstance().installHelpButton(this, ContextHelp.Corner.TOP_RIGHT, 6);
        ContextHelp.getInstance().add((JComponent)this.getContentPane(), "Explore/Organize");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                JOrganizeDialog.this.onOpened();
            }
        });
    }

    private void onOpened() {
        Tracer.getInstance().trace("Organize dialog opened");
        this.monitor = new ProgressMonitor(this, Msg.get("ui.countingObjects"), null, 1, 100);
        SwingWorker<CategoryCounters, Object> worker = new SwingWorker<CategoryCounters, Object>(){

            @Override
            protected CategoryCounters doInBackground() throws Exception {
                JOrganizeDialog.this.counters.addPropertyChangeListener(Category.folder, evt -> {
                    int current = JOrganizeDialog.this.counters.getFileCount();
                    JOrganizeDialog.this.monitor.setMaximum(current + 100);
                    JOrganizeDialog.this.monitor.setProgress(current);
                    if (JOrganizeDialog.this.monitor.isCanceled() || !JOrganizeDialog.this.isVisible()) {
                        throw new OperationAbortedException("monitor.isCanceled(): " + JOrganizeDialog.this.monitor.isCanceled() + "isVisible: " + JOrganizeDialog.this.isVisible());
                    }
                });
                JAlbumUtilities.countCategories(JOrganizeDialog.this.selectedObjects, JOrganizeDialog.this.counters, true);
                return JOrganizeDialog.this.counters;
            }

            @Override
            protected void done() {
                block3: {
                    try {
                        int current = JOrganizeDialog.this.counters.getFileCount();
                        JOrganizeDialog.this.monitor.setMaximum(current);
                        JOrganizeDialog.this.monitor.setProgress(current);
                        this.get();
                        JOrganizeDialog.this.okAction.setEnabled(JOrganizeDialog.this.onInitDone());
                    }
                    catch (InterruptedException current) {
                    }
                    catch (ExecutionException ex) {
                        if (ex.getCause() instanceof OperationAbortedException) break block3;
                        Debug.showErrorDialog(JOrganizeDialog.this.window, ex);
                    }
                }
            }
        };
        worker.execute();
    }

    protected boolean onInitDone() {
        return true;
    }

    protected static boolean isDuplicate(AlbumObject ao1, AlbumObject ao2) {
        try {
            return ao1.getFile().length() == ao2.getFile().length() && ao1.getMetadata().getCameraDate() == ao2.getMetadata().getCameraDate() && ao1.getMetadata().getCameraDate() != 0L && !ao1.getFile().getCanonicalFile().equals(ao2.getFile().getCanonicalFile());
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected abstract Action getOkAction();

    protected void treeDeleteEmpty(AlbumObject folder, AlbumObject root) throws IOException, PermissionException {
        if (folder.getChildren(false).isEmpty()) {
            folder.delete();
            AlbumObject parent = folder.getParent();
            if (parent != null && parent.isWithin(root)) {
                this.treeDeleteEmpty(parent, root);
            }
        }
    }

    protected void toList(List<AlbumObject> objects, List<AlbumObject> dest, Consumer<AlbumObject> forEach) throws InterruptedException {
        this.executorPool = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.MILLISECONDS, new LimitedQueue<Runnable>(8), new NamedThreadFactory("Metadata reader"));
        this.doToList(objects, dest, forEach);
        this.executorPool.shutdown();
        this.executorPool.awaitTermination(1L, TimeUnit.MINUTES);
    }

    private void doToList(List<AlbumObject> objects, List<AlbumObject> dest, Consumer<AlbumObject> forEach) throws InterruptedException {
        if (objects != null) {
            for (AlbumObject ao : objects) {
                if (ao.isFolder()) {
                    if (ao.isLink() || ao.isHidden() || ao.isView()) continue;
                    this.doToList(ao.getChildren(), dest, forEach);
                    continue;
                }
                if (ao.getCategory() == Category.webPage) continue;
                if (this.executorPool.isShutdown()) {
                    throw new OperationAbortedException();
                }
                this.executorPool.submit(() -> {
                    forEach.accept(ao);
                    Object object = this;
                    synchronized (object) {
                        this.monitor.setProgress(++this.processed);
                        this.monitor.setNote(ao.getName());
                        if (this.monitor.isCanceled() || !this.isVisible()) {
                            this.executorPool.shutdownNow();
                        }
                    }
                    object = dest;
                    synchronized (object) {
                        dest.add(ao);
                    }
                    return null;
                });
            }
        }
    }
}

