/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.JLinkLabel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.structure.AbstractGroupsPanel;
import se.datadosen.jalbum.structure.DayOptions;
import se.datadosen.jalbum.structure.MonthOptions;
import se.datadosen.jalbum.structure.TreeNodeImpl;
import se.datadosen.jalbum.structure.YearOptions;
import se.datadosen.util.annotations.Text;

public class JDateGroupsPanel
extends AbstractGroupsPanel {
    private final JPanel presetsPanel = new AbstractGroupsPanel.JRespectingPanel((LayoutManager)new MigLayout("insets 0, wrap2", "[fill][fill]"));
    private final JLinkLabel datePatternLink = new JLinkLabel("http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html", Msg.get("ui.dateAndTimePatterns"));
    private List<Calendar> samples;
    private List<String> patternGroups = new ArrayList<String>();
    @Text(value="effects.presets")
    JLabel presetsLabel = new AbstractGroupsPanel.JRespectingLabel();
    @Text(value="preset.yearMonth")
    private Action yearMonthPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JDateGroupsPanel.this.setOptions(YearOptions.FOUR_DIGIT_YEAR, MonthOptions.CUSTOM, DayOptions.NONE);
            JDateGroupsPanel.this.patterns[1].setText("MMM yyyy");
        }
    };
    @Text(value="preset.yearAndMonth")
    private Action yearAndMonthPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JDateGroupsPanel.this.setOptions(YearOptions.CUSTOM, MonthOptions.NONE, DayOptions.NONE);
            JDateGroupsPanel.this.patterns[0].setText("YYYY-MM");
        }
    };
    @Text(value="preset.months")
    private Action monthsPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JDateGroupsPanel.this.setOptions(YearOptions.NONE, MonthOptions.LONG_MONTH, DayOptions.NONE);
        }
    };
    @Text(value="preset.days")
    private Action daysPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JDateGroupsPanel.this.setOptions(YearOptions.NONE, MonthOptions.CUSTOM, DayOptions.NONE);
            JDateGroupsPanel.this.patterns[1].setText("MMM d");
        }
    };
    @Text(value="preset.dates")
    private Action datesPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JDateGroupsPanel.this.setOptions(YearOptions.CUSTOM, MonthOptions.NONE, DayOptions.NONE);
            JDateGroupsPanel.this.patterns[0].setText("YYYY-MM-dd");
        }
    };
    @Text(value="preset.weekdays")
    private Action weekdaysPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JDateGroupsPanel.this.setOptions(YearOptions.NONE, MonthOptions.NONE, DayOptions.CUSTOM);
            JDateGroupsPanel.this.patterns[2].setText("E d");
        }
    };

    public JDateGroupsPanel(JTree samplesTree) {
        super(samplesTree, new AbstractGroupsPanel.JRespectingComboBox<YearOptions>(YearOptions.values()), new AbstractGroupsPanel.JRespectingComboBox<MonthOptions>(MonthOptions.values()), new AbstractGroupsPanel.JRespectingComboBox<DayOptions>(DayOptions.values()));
        this.init();
    }

    private void init() {
        Msg.setTexts(this);
        this.setLayout((LayoutManager)new MigLayout("insets 5, wrap 4", "[][][][]"));
        this.setBorder(new TitledBorder(Msg.get("ui.groups")));
        this.add((Component)this.groups[0], "span 3, growx");
        this.add(this.patterns[0]);
        this.add(Box.createHorizontalStrut(16));
        this.add((Component)this.groups[1], "growx, span 2");
        this.add(this.patterns[1]);
        this.add(Box.createHorizontalStrut(32), "span 2");
        this.add((Component)this.groups[2], "growx");
        this.add(this.patterns[2]);
        this.presetsLabel.setFont(this.presetsLabel.getFont().deriveFont(1));
        this.add((Component)this.presetsLabel, "wrap 4");
        this.presetsPanel.add(new JButton(this.yearMonthPreset));
        this.presetsPanel.add(new JButton(this.yearAndMonthPreset));
        this.presetsPanel.add(new JButton(this.monthsPreset));
        this.presetsPanel.add(new JButton(this.datesPreset));
        this.presetsPanel.add(new JButton(this.daysPreset));
        this.presetsPanel.add(new JButton(this.weekdaysPreset));
        this.add((Component)this.presetsPanel, "growx, growy, span 4");
        this.add((Component)this.datePatternLink, "span 4");
        this.groups[0].setSelectedItem(YearOptions.FOUR_DIGIT_YEAR);
        this.groups[1].setSelectedItem(MonthOptions.SHORT_MONTH);
        this.groups[2].setSelectedItem(DayOptions.NONE);
    }

    @Override
    protected void setPresetsEnabledState() {
        this.yearMonthPreset.setEnabled(this.presetsPanel.isEnabled());
        this.yearAndMonthPreset.setEnabled(this.presetsPanel.isEnabled());
        this.monthsPreset.setEnabled(this.presetsPanel.isEnabled());
        this.datesPreset.setEnabled(this.presetsPanel.isEnabled());
        this.daysPreset.setEnabled(this.presetsPanel.isEnabled());
        this.weekdaysPreset.setEnabled(this.presetsPanel.isEnabled());
    }

    @Override
    protected TreeNodeImpl createSampleModel(List<String> patternGroups) {
        TreeNodeImpl root = new TreeNodeImpl("");
        if (this.samples == null) {
            this.samples = this.generateSamples();
        }
        for (Calendar cal : this.samples) {
            TreeNodeImpl parent = root;
            for (String pattern : patternGroups) {
                if (pattern.length() <= 0) continue;
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                    String datePart = formatter.format(cal.getTime());
                    TreeNodeImpl node = parent.getChild(datePart);
                    if (node == null) {
                        node = new TreeNodeImpl(datePart);
                        parent.addChild(node);
                    }
                    parent = node;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return root;
    }

    private List<Calendar> generateSamples() {
        int startYear;
        ArrayList<Calendar> samples = new ArrayList<Calendar>();
        Date now = new Date();
        Calendar nowCalendar = GregorianCalendar.getInstance();
        nowCalendar.setTime(now);
        int year = startYear = nowCalendar.get(1);
        int i = 0;
        while (i < 3) {
            for (int month = 0; month < 3; ++month) {
                for (int day = 1; day <= 3; ++day) {
                    samples.add(new GregorianCalendar(year, month, day));
                }
            }
            ++i;
            --year;
        }
        return samples;
    }
}

