/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import com.adobe.internal.xmp.XMPException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.jalbum.undo.UndoHandler;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.jalbum.structure.JOrganizeDialog;
import se.datadosen.util.Debug;

public class JCreatorGroupingDialog
extends JOrganizeDialog {
    protected JCheckBox deleteEmptyFolders = new JCheckBox(Msg.get("ui.deleteEmptyFolders"), true);
    private final Action okAction = new AbstractAction(Msg.get("edit.processNObjects", "-----")){
        {
            this.setEnabled(false);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.putValue("Name", Msg.get("edit.processNObjects", JCreatorGroupingDialog.this.counters.getFileCount()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("Group by creator");
            this.setEnabled(false);
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    UndoHandler.getInstance().undoableEditHappened(this, JCreatorGroupingDialog.this.groupEdit);
                    JCreatorGroupingDialog.this.group(JCreatorGroupingDialog.this.selectedObjects, JCreatorGroupingDialog.this.destinationFolder);
                    return null;
                }

                @Override
                protected void done() {
                    block3: {
                        JCreatorGroupingDialog.this.groupEdit.end();
                        UndoHandler.getInstance().update();
                        JCreatorGroupingDialog.this.window.albumExplorer.redraw();
                        try {
                            JCreatorGroupingDialog.this.logSave(JCreatorGroupingDialog.this.destinationFolder);
                            JCreatorGroupingDialog.this.organizingDone();
                            this.get();
                            JCreatorGroupingDialog.this.setVisible(false);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof OperationAbortedException) break block3;
                            Debug.showErrorDialog(JCreatorGroupingDialog.this, cause);
                        }
                    }
                    this.setEnabled(true);
                }
            };
            worker.execute();
        }
    };

    private String getCreator(AlbumObject ao) {
        try {
            String creator;
            XmpManager mgr = ao.getXmpManager();
            if (mgr != null && (creator = mgr.getCreator()) != null) {
                return creator;
            }
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        return "";
    }

    public void group(List<AlbumObject> objects, AlbumObject dest) throws IOException, PermissionException, InterruptedException, XMPException {
        if (objects != null) {
            ArrayList<AlbumObject> list = new ArrayList<AlbumObject>();
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("engine.readingMetadataInfo"), null, 1, this.counters.getFileCount());
            this.toList(objects, list, ao -> ao.getXmpManager());
            list.sort((o1, o2) -> this.getCreator((AlbumObject)o1).compareTo(this.getCreator((AlbumObject)o2)));
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("ui.grouping"), null, 1, this.counters.getFileCount());
            for (AlbumObject ao2 : list) {
                this.processObject(ao2, dest);
            }
        }
    }

    private void processObject(AlbumObject ao, AlbumObject dest) throws IOException, PermissionException {
        String creator = this.getCreator(ao);
        if (creator.length() > 0) {
            AlbumObject parent = dest;
            AlbumObject folder = parent.getChild(creator);
            if (folder == null) {
                folder = parent.createFolder(this.insertIndex++, creator);
            }
            parent = folder;
            if (!ao.getFile().getParentFile().equals(parent.getFile())) {
                AlbumObject oldParent = ao.getParent();
                AlbumObject existing = parent.getChild(ao.getName());
                if (existing != null && JCreatorGroupingDialog.isDuplicate(existing, ao)) {
                    System.out.println(Msg.get("edit.deletingDuplicateFile", ao));
                    ao.delete();
                } else {
                    this.move(ao, parent, parent.getUniqueName(ao.getName()));
                }
                if (this.deleteEmptyFolders.isSelected() && oldParent.getChildren().isEmpty()) {
                    try {
                        this.treeDeleteEmpty(oldParent, dest);
                    }
                    catch (IOException | PermissionException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
            this.monitor.setProgress(++this.processed);
            this.monitor.setNote(ao.getName());
            if (this.monitor.isCanceled() || !this.isVisible()) {
                throw new OperationAbortedException();
            }
        }
    }

    public JCreatorGroupingDialog(JAlbumFrame window, List<AlbumObject> selectedObjects, AlbumObject dest, int insertIndex) {
        super(window, Msg.get("edit.groupByCreator"), selectedObjects, dest, insertIndex);
        this.init();
    }

    @Override
    protected void init() {
        Msg.maintainTranslated(this);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.add(this.deleteEmptyFolders);
        super.init();
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }
}

