/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import biweekly.Biweekly;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.io.chain.ChainingTextStringParser;
import biweekly.property.DateStart;
import biweekly.property.DurationProperty;
import biweekly.property.ICalProperty;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import com.adobe.internal.xmp.XMPException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.jalbum.undo.UndoHandler;
import se.datadosen.component.JFileSelector;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.jalbum.structure.JOrganizeDialog;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.StringUtil;

public class JCalendarGroupingDialog
extends JOrganizeDialog {
    final Preferences prefs = Preferences.userNodeForPackage(JCalendarGroupingDialog.class);
    JLabel calendarFileLabel = new JLabel(Msg.get("ui.selectCalendarFilePrompt"));
    JSmartTextField calendarURLField = new JSmartTextField(30);
    JFileSelector calendarFileSelector = new JFileSelector(Msg.get("ui.selectCalendarFileTitle"), this.calendarURLField);
    JButton exampleButton = new JButton(new LambdaAction(Msg.get("ui.example"), ae -> this.calendarURLField.setText("http://jalbum.net/download/Seasons.ics")));
    JCheckBox includeSingleEvents = new JCheckBox(Msg.get("ui.includeSingleEvents"), this.prefs.getBoolean("includeSingleEvents", true));
    JCheckBox includeRecurringEvents = new JCheckBox(Msg.get("ui.includeRecurringEvents"), this.prefs.getBoolean("includeRecurringEvents", true));
    JCheckBox tagImagesWithEvents = new JCheckBox(Msg.get("ui.tagImagesWithMatchingEvents"), this.prefs.getBoolean("tagImagesWithEvents", false));
    private ICalendar calendar;
    TimezoneInfo tzinfo;
    List<VEvent> events = new ArrayList<VEvent>();
    List<VEvent> recurringEvents = new ArrayList<VEvent>();
    private final Action okAction = new AbstractAction(Msg.get("edit.processNObjects", "-----")){
        {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("Group by calendar");
            JCalendarGroupingDialog.this.prefs.put("calendarURL", JCalendarGroupingDialog.this.calendarURLField.getText());
            JCalendarGroupingDialog.this.prefs.putBoolean("includeSingleEvents", JCalendarGroupingDialog.this.includeSingleEvents.isSelected());
            JCalendarGroupingDialog.this.prefs.putBoolean("includeRecurringEvents", JCalendarGroupingDialog.this.includeRecurringEvents.isSelected());
            JCalendarGroupingDialog.this.prefs.putBoolean("tagImagesWithEvents", JCalendarGroupingDialog.this.tagImagesWithEvents.isSelected());
            try {
                URL u = new URL(JCalendarGroupingDialog.this.calendarURLField.getText());
                ChainingTextStringParser parser = Biweekly.parse((String)IO.readTextUrl(u));
                JCalendarGroupingDialog.this.calendar = parser.first();
                JCalendarGroupingDialog.this.tzinfo = JCalendarGroupingDialog.this.calendar.getTimezoneInfo();
                for (ICalendar cal : parser.all()) {
                    for (VEvent event : cal.getEvents()) {
                        if (event.getRecurrenceRule() != null) {
                            JCalendarGroupingDialog.this.recurringEvents.add(event);
                            continue;
                        }
                        JCalendarGroupingDialog.this.events.add(event);
                    }
                }
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JCalendarGroupingDialog.this, ex);
            }
            this.setEnabled(false);
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    UndoHandler.getInstance().undoableEditHappened(this, JCalendarGroupingDialog.this.groupEdit);
                    JCalendarGroupingDialog.this.group(JCalendarGroupingDialog.this.selectedObjects, JCalendarGroupingDialog.this.destinationFolder);
                    return null;
                }

                @Override
                protected void done() {
                    block3: {
                        JCalendarGroupingDialog.this.groupEdit.end();
                        UndoHandler.getInstance().update();
                        JCalendarGroupingDialog.this.window.albumExplorer.redraw();
                        try {
                            JCalendarGroupingDialog.this.logSave(JCalendarGroupingDialog.this.destinationFolder);
                            JCalendarGroupingDialog.this.organizingDone();
                            this.get();
                            JCalendarGroupingDialog.this.setVisible(false);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof OperationAbortedException) break block3;
                            Debug.showErrorDialog(JCalendarGroupingDialog.this, cause);
                        }
                    }
                    this.setEnabled(true);
                }
            };
            worker.execute();
        }
    };
    private long iterations;

    private boolean isValidCalendarURL() {
        try {
            URL u = new URL(this.calendarURLField.getText());
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    @Override
    protected boolean onInitDone() {
        this.okAction.putValue("Name", Msg.get("edit.processNObjects", this.counters.getFileCount()));
        return this.isValidCalendarURL();
    }

    private long getCameraDate(AlbumObject ao) {
        return ao.getCameraDate() != 0L ? ao.getCameraDate() : ao.getLastModified();
    }

    public void group(List<AlbumObject> objects, AlbumObject dest) throws IOException, PermissionException, InterruptedException, XMPException {
        if (objects != null && objects.size() > 0) {
            ArrayList<AlbumObject> list = new ArrayList<AlbumObject>();
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("engine.readingMetadataInfo"), null, 1, this.counters.getFileCount());
            this.toList(objects, list, ao -> ao.getXmpManager());
            list.sort((o1, o2) -> (int)(this.getCameraDate((AlbumObject)o1) / 1000L - this.getCameraDate((AlbumObject)o2) / 1000L));
            this.stripPastEvents(this.getCameraDate(list.get(0)));
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("ui.grouping"), null, 1, this.counters.getFileCount());
            Stopwatch sw = new Stopwatch("Grouping").start();
            for (AlbumObject ao2 : list) {
                this.processObject(ao2, dest);
            }
        }
    }

    private void processObject(AlbumObject ao, AlbumObject dest) throws IOException, XMPException, PermissionException {
        AlbumObject parent = dest;
        long cameraDate = this.getCameraDate(ao);
        List<VEvent> result = this.findEventsByDate(new Date(cameraDate), this.calendar);
        if (result.size() > 0) {
            for (VEvent event : result) {
                String name;
                String string = name = event.getSummary() != null ? (String)event.getSummary().getValue() : null;
                if (name != null && name.length() > 0) {
                    String wsName = IO.webSafe(name);
                    AlbumObject folder = parent.getChild(wsName);
                    if (folder == null) {
                        folder = parent == dest ? parent.createFolder(this.insertIndex++, wsName) : parent.createFolder(wsName);
                    }
                    parent = folder;
                }
                if (ao.getFile().getParentFile().equals(parent.getFile())) continue;
                AlbumObject oldParent = ao.getParent();
                AlbumObject existing = parent.getChild(ao.getName());
                if (existing != null && JCalendarGroupingDialog.isDuplicate(existing, ao)) {
                    System.out.println(Msg.get("edit.deletingDuplicateFile", ao));
                    ao.delete();
                    continue;
                }
                this.move(ao, parent, parent.getUniqueName(ao.getName()));
            }
            if (this.tagImagesWithEvents.isSelected() && ao.getXmpManager() != null) {
                XmpManager mgr = ao.getXmpManager();
                Set<String> keywords = mgr.getKeywordSet();
                boolean modified = false;
                for (VEvent event : result) {
                    String name = event.getSummary() != null ? (String)event.getSummary().getValue() : null;
                    if (name == null || name.length() <= 0 || !keywords.add(name)) continue;
                    modified = true;
                }
                if (modified) {
                    mgr.setKeywords(StringUtil.setToString(keywords));
                    mgr.save(true);
                }
            }
        }
        this.monitor.setProgress(++this.processed);
        this.monitor.setNote(ao.getName());
        if (this.monitor.isCanceled() || !this.isVisible()) {
            throw new OperationAbortedException();
        }
    }

    public JCalendarGroupingDialog(JAlbumFrame window, List<AlbumObject> selectedObjects, AlbumObject dest, int insertIndex) {
        super(window, Msg.get("edit.groupByCalendar"), selectedObjects, dest, insertIndex);
        this.init();
    }

    @Override
    protected void init() {
        Msg.maintainTranslated(this);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new RiverLayout());
        this.add(this.calendarFileLabel);
        this.add("br hfill", this.calendarURLField);
        this.add(this.calendarFileSelector);
        this.add(this.exampleButton);
        this.add("p", this.includeSingleEvents);
        this.add("br", this.includeRecurringEvents);
        this.add("br", this.tagImagesWithEvents);
        super.init();
        this.calendarFileSelector.setFileFilter(new FileNameExtensionFilter(Msg.get("ui.calendarFiles"), "ics", "ical", "icalendar", "ifb"));
        this.calendarFileSelector.setURLFormat(true);
        this.calendarURLField.onChange(de -> this.okAction.setEnabled(this.isValidCalendarURL()));
        String url = this.prefs.get("calendarURL", null);
        if (url != null) {
            this.calendarURLField.setText(url);
        }
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }

    private void addEvents(List<VEvent> events, ICalendar cal, boolean recurring, Date testDate, List<VEvent> result) {
        block0: for (VEvent event : events) {
            TimezoneAssignment dtstartTimezone;
            DateStart dtstart = event.getDateStart();
            TimeZone timezone = this.tzinfo.isFloating((ICalProperty)dtstart) ? TimeZone.getDefault() : ((dtstartTimezone = this.tzinfo.getTimezone((ICalProperty)dtstart)) == null ? TimeZone.getTimeZone("UTC") : dtstartTimezone.getTimeZone());
            DateIterator it = event.getDateIterator(timezone);
            long duration = ((ICalDate)event.getDateEnd().getValue()).getTime() - ((ICalDate)event.getDateStart().getValue()).getTime();
            while (it.hasNext()) {
                ++this.iterations;
                Date start = (Date)it.next();
                if (!recurring && start.after(testDate)) {
                    return;
                }
                if (testDate.getTime() >= start.getTime() && testDate.getTime() <= start.getTime() + duration) {
                    result.add(event);
                }
                if (!start.after(testDate)) continue;
                continue block0;
            }
        }
    }

    List<VEvent> findEventsByDate(Date testDate, ICalendar cal) {
        ArrayList<VEvent> result = new ArrayList<VEvent>();
        if (this.includeSingleEvents.isSelected()) {
            this.addEvents(this.events, cal, false, testDate, result);
        }
        if (this.includeRecurringEvents.isSelected()) {
            this.addEvents(this.recurringEvents, cal, true, testDate, result);
        }
        this.events.sort((ve1, ve2) -> (int)(JCalendarGroupingDialog.getDuration(ve2) - JCalendarGroupingDialog.getDuration(ve1)));
        return result;
    }

    private static long getDuration(VEvent event) {
        DurationProperty durationProp = event.getDuration();
        return durationProp != null ? ((Duration)durationProp.getValue()).toMillis() : 0L;
    }

    private void stripPastEvents(long testDate) {
        this.events = this.events.stream().filter(ve -> ((ICalDate)ve.getDateEnd().getValue()).getTime() >= testDate).sorted((ve1, ve2) -> ((ICalDate)ve1.getDateStart().getValue()).compareTo((Date)ve2.getDateStart().getValue())).collect(Collectors.toList());
    }
}

