/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.jalbum.undo.UndoHandler;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.structure.JOrganizeDialog;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.util.Debug;

public class JAlphabeticalGroupingDialog
extends JOrganizeDialog {
    int processed = 0;
    protected JCheckBox deleteEmptyFolders = new JCheckBox(Msg.get("ui.deleteEmptyFolders"), true);
    private final Action okAction = new AbstractAction(Msg.get("edit.processNObjects", "-----")){
        {
            this.setEnabled(false);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.putValue("Name", Msg.get("edit.processNObjects", JAlphabeticalGroupingDialog.this.counters.getFileCount()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("Group alphabetically");
            this.setEnabled(false);
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    UndoHandler.getInstance().undoableEditHappened(this, JAlphabeticalGroupingDialog.this.groupEdit);
                    JAlphabeticalGroupingDialog.this.group(JAlphabeticalGroupingDialog.this.selectedObjects, JAlphabeticalGroupingDialog.this.destinationFolder);
                    return null;
                }

                @Override
                protected void done() {
                    block3: {
                        JAlphabeticalGroupingDialog.this.groupEdit.end();
                        UndoHandler.getInstance().update();
                        JAlphabeticalGroupingDialog.this.window.albumExplorer.redraw();
                        try {
                            JAlphabeticalGroupingDialog.this.logSave(JAlphabeticalGroupingDialog.this.destinationFolder);
                            JAlphabeticalGroupingDialog.this.organizingDone();
                            this.get();
                            JAlphabeticalGroupingDialog.this.setVisible(false);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof OperationAbortedException) break block3;
                            Debug.showErrorDialog(JAlphabeticalGroupingDialog.this, cause);
                        }
                    }
                    this.setEnabled(true);
                }
            };
            worker.execute();
        }
    };

    public void group(List<AlbumObject> objects, AlbumObject dest) throws IOException, PermissionException {
        if (objects != null) {
            List list = Support.toStream(objects).sorted((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName())).collect(Collectors.toList());
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("ui.grouping"), null, 1, this.counters.getFileCount());
            for (AlbumObject ao : list) {
                this.processObject(ao, dest);
            }
        }
    }

    private void processObject(AlbumObject ao, AlbumObject dest) throws IOException, PermissionException {
        AlbumObject parent = dest;
        String initial = Character.toString(ao.getName().charAt(0)).toUpperCase();
        AlbumObject folder = parent.getChild(initial);
        if (folder == null) {
            folder = parent.createFolder(this.insertIndex++, initial);
        }
        parent = folder;
        if (!ao.getFile().getParentFile().equals(parent.getFile())) {
            AlbumObject oldParent = ao.getParent();
            AlbumObject existing = parent.getChild(ao.getName());
            if (existing != null && JAlphabeticalGroupingDialog.isDuplicate(existing, ao)) {
                System.out.println(Msg.get("edit.deletingDuplicateFile", ao));
                ao.delete();
            } else {
                this.move(ao, parent, parent.getUniqueName(ao.getName()));
            }
            if (this.deleteEmptyFolders.isSelected() && oldParent.getChildren().isEmpty()) {
                try {
                    this.treeDeleteEmpty(oldParent, dest);
                }
                catch (IOException | PermissionException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        }
        this.monitor.setProgress(++this.processed);
        this.monitor.setNote(ao.getName());
        if (this.monitor.isCanceled() || !this.isVisible()) {
            throw new OperationAbortedException();
        }
    }

    public JAlphabeticalGroupingDialog(JAlbumFrame window, List<AlbumObject> selectedObjects, AlbumObject dest, int insertIndex) {
        super(window, Msg.get("edit.groupAlpha"), selectedObjects, dest, insertIndex);
        this.init();
    }

    @Override
    protected void init() {
        Msg.maintainTranslated(this);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.add(this.deleteEmptyFolders);
        super.init();
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }
}

