/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.util.Objects;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import net.jalbum.ObjectException;
import net.jalbum.script.GroovierScriptEngine;
import net.jalbum.util.ReadOnlyProxy;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.jsr223.GroovyScriptEngineFactory;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.jalbum.structure.Transformer;

public class CustomFilterTransformer
implements Transformer<CustomFilterTransformer> {
    private String filterExpression = "obj.category==Category.video // Videos";
    private transient CompiledScript compiled;
    private transient AlbumObject tree;
    private transient GroovierScriptEngine scriptEngine;
    private static final transient GroovyScriptEngineFactory groovyFactory = new GroovyScriptEngineFactory();

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) throws ObjectException {
        this.tree = tree;
        this.init();
        Support.toStream(tree).filter(ao -> this.eval((AlbumObject)ao)).forEach(ao -> newRoot.addFileOf((AlbumObject)ao));
        return newRoot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean eval(AlbumObject ao) {
        AlbumObject readOnlyObj = ReadOnlyProxy.createReadOnlyProxy(ao, AlbumObject.class);
        GroovierScriptEngine groovierScriptEngine = this.scriptEngine;
        synchronized (groovierScriptEngine) {
            try {
                Bindings b = this.scriptEngine.getBindings(100);
                b.put("ao", (Object)readOnlyObj);
                b.put("obj", (Object)readOnlyObj);
                Object res = this.compiled.eval();
                boolean bl = Boolean.TRUE.equals(res);
                return bl;
            }
            catch (ScriptException ex) {
                throw new ObjectException(ao, "Error evaluating custom filter script", ex);
            }
            finally {
                if (ao.getFactory().isForAlbumMaking()) {
                    ((AlbumObjectImpl)ao).invalidateVars();
                }
            }
        }
    }

    private void init() {
        this.scriptEngine = new GroovierScriptEngine((ScriptEngineFactory)groovyFactory, this.tree.getEngine().getScriptEnvironment().classLoader, new CompilerConfiguration(CompilerConfiguration.DEFAULT));
        this.scriptEngine.addImports("java.awt.*", "java.awt.event.*", "javax.swing.*", "javax.swing.event.*", "se.datadosen.jalbum.*", "static se.datadosen.jalbum.JAlbumUtilities.*", "se.datadosen.util.*", "static se.datadosen.util.Colors.hex8", "se.datadosen.explorer.*", "se.datadosen.component.*", "se.datadosen.tags.*", "net.jalbum.*", "net.jalbum.util.*", "net.miginfocom.swing.*");
        try {
            this.compiled = this.scriptEngine.compile(this.filterExpression);
        }
        catch (ScriptException ex) {
            throw new ObjectException(null, "Error compiling expression", ex);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.filterExpression);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomFilterTransformer other = (CustomFilterTransformer)obj;
        return Objects.equals(this.filterExpression, other.filterExpression);
    }

    @Override
    public CustomFilterTransformer copy() {
        CustomFilterTransformer copy = new CustomFilterTransformer();
        copy.filterExpression = this.filterExpression;
        return copy;
    }

    public String toString() {
        return "CustomFilterTransformer{filterExpression=" + this.filterExpression + "}";
    }
}

